/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.adapter;

import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.adapter.OffsetWorld;
import org.checkerframework.dataflow.qual.Pure;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface OffsetLocation {
    public OffsetWorld getWorld();

    public double getX();

    public double getY();

    public double getZ();

    @Deprecated
    default public @Nullable String getWorldName() {
        return this.getWorld().getName();
    }

    @Pure
    public OffsetLocation apply(FixedOffset var1);

    @Pure
    public OffsetLocation unapply(FixedOffset var1);

    default public @Nullable Double getDistance(OffsetLocation other) {
        if (!this.getWorld().equals(other.getWorld())) {
            return null;
        }
        return Math.sqrt(Math.pow(this.getX() - other.getX(), 2.0) + Math.pow(this.getY() - other.getY(), 2.0) + Math.pow(this.getZ() - other.getZ(), 2.0));
    }

    public Object getPlatformLocationObject();
}

