/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.Offset;
import java.util.Random;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record ScalableOffset(int x, int z) implements Offset
{
    static final Random RANDOM = new Random();

    @Override
    public String toString() {
        return "[x=" + this.x + ", z=" + this.z + "]";
    }

    @Override
    public ScalableOffset negate() {
        return new ScalableOffset(-this.x, -this.z);
    }

    @Override
    public boolean isZero() {
        return this.x == 0 && this.z == 0;
    }

    public FixedOffset scaleDownBy(double divisor) {
        return new FixedOffset(Offset.alignComponent((int)((double)this.x / divisor), 0), Offset.alignComponent((int)((double)this.z / divisor), 0));
    }
}

