/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetChange;
import com.jtprince.coordinateoffset.OffsetData;
import com.jtprince.coordinateoffset.OffsetFactory;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.command.OffsetSetCommand;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class OffsetHolder {
    private final CoordinateOffsetCore core;
    private final OffsetFactory offsetFactory;
    private final ConcurrentHashMap<UUID, PlayerOffsetData> playerOffsetData = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Object> pendingDataLocks = new ConcurrentHashMap();

    OffsetHolder(CoordinateOffsetCore core) {
        this.core = core;
        this.offsetFactory = new OffsetFactory(core);
    }

    public OffsetData getOffset(OffsetPlayer player) {
        PlayerOffsetData data = this.playerOffsetData.get(player.getUuid());
        if (data == null) {
            throw new NoSuchElementException("Player " + player.getName() + " has no offset data!");
        }
        return data.currentOffset;
    }

    public OffsetData getNextOffset(OffsetPlayer player) {
        PlayerOffsetData data = this.playerOffsetData.get(player.getUuid());
        if (data == null) {
            throw new NoSuchElementException("Player " + player.getName() + " has no offset data!");
        }
        return data.nextOffset == null ? data.currentOffset : data.nextOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedOffset waitForJoiningOffset(UUID playerUuid, int timeoutMillis) throws TimeoutException {
        PlayerOffsetData data = this.playerOffsetData.get(playerUuid);
        if (data == null && timeoutMillis > 0) {
            Object pendingOffsetDataLock = this.pendingDataLocks.computeIfAbsent(playerUuid, uuid -> new Object());
            long now = System.currentTimeMillis();
            long deadline = now + (long)timeoutMillis;
            Object object = pendingOffsetDataLock;
            synchronized (object) {
                while (data == null && (now = System.currentTimeMillis()) < deadline) {
                    try {
                        pendingOffsetDataLock.wait(deadline - now);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    data = this.playerOffsetData.get(playerUuid);
                }
            }
        }
        if (data == null) {
            throw new TimeoutException("Player " + String.valueOf(playerUuid) + " has no offset data!");
        }
        return data.currentOffset.offset();
    }

    public OffsetChange generateNextOffset(OffsetPlayer player, @Nullable OffsetLocation previousLocation, OffsetLocation nextLocation, OffsetProviderContext.ProvideReason reason) {
        PlayerOffsetData data = this.playerOffsetData.get(player.getUuid());
        OffsetProviderContext context = new OffsetProviderContext(player, previousLocation, nextLocation, data == null ? null : data.currentOffset.offset(), reason);
        OffsetData creation = this.offsetFactory.createOffset(context);
        return this.setNextOffset(context.player().getUuid(), creation);
    }

    public OffsetChange setNextOffsetByCommand(OffsetPlayer player, OffsetSetCommand setCommand) {
        PlayerOffsetData playerCache = this.playerOffsetData.get(player.getUuid());
        OffsetData currentOffsetData = playerCache == null ? null : playerCache.currentOffset;
        FixedOffset currentOffset = currentOffsetData == null ? null : currentOffsetData.offset();
        OffsetProviderContext context = new OffsetProviderContext(player, player.getLocation(), player.getLocation(), currentOffset, OffsetProviderContext.ProvideReason.COMMAND_SET);
        OffsetProvider affectedProvider = this.getAffectedProvider(currentOffsetData);
        if (affectedProvider != null) {
            try {
                affectedProvider.onOffsetSetByCommand(setCommand, player);
            }
            catch (Exception e) {
                new RuntimeException("Error informing affected offset provider " + affectedProvider.name + " of offset set by command.", e).printStackTrace();
            }
        }
        OffsetData creation = this.offsetFactory.createSpecificOffset(setCommand.getOffset(), new OffsetData.Source.SetCommand(setCommand, affectedProvider), context);
        return this.setNextOffset(player.getUuid(), creation);
    }

    public OffsetChange setNextOffsetByPlugin(OffsetPlayer player, Offset newOffset) {
        PlayerOffsetData playerCache = this.playerOffsetData.get(player.getUuid());
        OffsetData currentOffsetData = playerCache == null ? null : playerCache.currentOffset;
        FixedOffset currentOffset = currentOffsetData == null ? null : currentOffsetData.offset();
        OffsetProviderContext context = new OffsetProviderContext(player, player.getLocation(), player.getLocation(), currentOffset, OffsetProviderContext.ProvideReason.PLUGIN_SET);
        return this.setNextOffset(player.getUuid(), this.offsetFactory.createSpecificOffset(newOffset, new OffsetData.Source.PluginSet(), context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffsetChange setNextOffset(UUID playerUuid, OffsetData newOffset) {
        Object pendingOffsetDataLock;
        PlayerOffsetData d = this.playerOffsetData.compute(playerUuid, (uuid, existingOffsetData) -> {
            if (existingOffsetData == null) {
                this.debugLog("Generate first: " + String.valueOf(newOffset) + ", " + String.valueOf(newOffset) + ", null");
                this.log(newOffset);
                return new PlayerOffsetData(newOffset, newOffset, null);
            }
            if (existingOffsetData.currentOffset.offset().equals(newOffset.offset())) {
                this.debugLog("Unchanged offset:" + String.valueOf(existingOffsetData.previousOffset) + " , " + String.valueOf(newOffset) + ", " + String.valueOf(existingOffsetData.nextOffset));
                return new PlayerOffsetData(existingOffsetData.previousOffset, newOffset, existingOffsetData.nextOffset);
            }
            this.debugLog("Generate next: " + String.valueOf(existingOffsetData.previousOffset) + ", " + String.valueOf(existingOffsetData.currentOffset) + ", " + String.valueOf(newOffset));
            return new PlayerOffsetData(existingOffsetData.previousOffset, existingOffsetData.currentOffset, newOffset);
        });
        Object object = pendingOffsetDataLock = this.pendingDataLocks.computeIfAbsent(playerUuid, uuid -> new Object());
        synchronized (object) {
            pendingOffsetDataLock.notifyAll();
        }
        OffsetChange offsetChange = new OffsetChange(d.currentOffset, d.nextOffset == null ? d.currentOffset : d.nextOffset);
        if (offsetChange.offsetChanged()) {
            this.log(offsetChange.newOffsetData());
        }
        return offsetChange;
    }

    public void swapInNextOffset(OffsetPlayer player) {
        this.playerOffsetData.computeIfPresent(player.getUuid(), (uuid, existingOffsetData) -> {
            if (existingOffsetData.nextOffset == null) {
                return existingOffsetData;
            }
            this.debugLog("Swap in next: " + String.valueOf(existingOffsetData.currentOffset) + ", " + String.valueOf(existingOffsetData.nextOffset) + ", null");
            return new PlayerOffsetData(existingOffsetData.currentOffset, existingOffsetData.nextOffset, null);
        });
    }

    public void remove(UUID uuid) {
        this.playerOffsetData.remove(uuid);
        this.pendingDataLocks.remove(uuid);
    }

    private void log(OffsetData offset) {
        if (!this.core.getConfig().getVerbose()) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append("Using offset ");
        s.append(offset.offset());
        s.append(" from ");
        OffsetData.Source source = offset.source();
        Objects.requireNonNull(source);
        OffsetData.Source source2 = source;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffsetData.Source.PermissionBypass.class, OffsetData.Source.BedrockBypass.class, OffsetData.Source.Provider.class, OffsetData.Source.SetCommand.class, OffsetData.Source.PluginSet.class}, (Object)source2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                OffsetData.Source.PermissionBypass ignored = (OffsetData.Source.PermissionBypass)source2;
                s.append("permission bypass");
                break;
            }
            case 1: {
                OffsetData.Source.BedrockBypass ignored = (OffsetData.Source.BedrockBypass)source2;
                return;
            }
            case 2: {
                OffsetData.Source.Provider p = (OffsetData.Source.Provider)source2;
                s.append("provider \"").append(p.provider().name).append("\"");
                if (p.overrideRuleIndex() != null) {
                    s.append(" (provider override rule #").append(p.overrideRuleIndex()).append(")");
                    break;
                }
                s.append(" (default provider)");
                break;
            }
            case 3: {
                OffsetData.Source.SetCommand p = (OffsetData.Source.SetCommand)source2;
                s.append("command by ").append(p.command().getCommandSender().name());
                break;
            }
            case 4: {
                OffsetData.Source.PluginSet ignored = (OffsetData.Source.PluginSet)source2;
                s.append("external plugin");
            }
        }
        s.append(" for player ");
        s.append(offset.context().player().getName());
        s.append(" in world \"");
        s.append(offset.context().playerLocation().getWorld().getName());
        s.append("\"");
        s.append(switch (offset.context().reason()) {
            default -> throw new MatchException(null, null);
            case OffsetProviderContext.ProvideReason.JOIN -> " (player joined)";
            case OffsetProviderContext.ProvideReason.DEATH_RESPAWN -> " (player respawned)";
            case OffsetProviderContext.ProvideReason.WORLD_CHANGE -> " (player changed worlds)";
            case OffsetProviderContext.ProvideReason.TELEPORT -> " (player teleported)";
            case OffsetProviderContext.ProvideReason.COMMAND_REGENERATE -> " (regenerated by command)";
            case OffsetProviderContext.ProvideReason.COMMAND_SET, OffsetProviderContext.ProvideReason.PLUGIN_SET -> "";
            case OffsetProviderContext.ProvideReason.PLUGIN_REGENERATE -> " (regenerated by external plugin)";
        });
        this.core.getLogger().info(s.toString());
    }

    private void debugLog(String message) {
        if (this.core.isDebugEnabled()) {
            this.core.getLogger().info("[Debug] " + message);
        }
    }

    private @Nullable OffsetProvider getAffectedProvider(@Nullable OffsetData currentOffset) {
        OffsetProvider affectedProvider;
        if (currentOffset == null) {
            return null;
        }
        OffsetData.Source source = currentOffset.source();
        Objects.requireNonNull(source);
        OffsetData.Source source2 = source;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffsetData.Source.BedrockBypass.class, OffsetData.Source.PermissionBypass.class, OffsetData.Source.Provider.class, OffsetData.Source.SetCommand.class, OffsetData.Source.PluginSet.class}, (Object)source2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                OffsetData.Source.BedrockBypass ignored = (OffsetData.Source.BedrockBypass)source2;
                OffsetProvider offsetProvider = null;
                break;
            }
            case 1: {
                OffsetData.Source.PermissionBypass ignored = (OffsetData.Source.PermissionBypass)source2;
                OffsetProvider offsetProvider = null;
                break;
            }
            case 2: {
                OffsetData.Source.Provider provider = (OffsetData.Source.Provider)source2;
                OffsetProvider offsetProvider = provider.provider();
                break;
            }
            case 3: {
                OffsetData.Source.SetCommand setCommand = (OffsetData.Source.SetCommand)source2;
                OffsetProvider offsetProvider = setCommand.affectedProvider();
                break;
            }
            case 4: {
                OffsetData.Source.PluginSet ignored = (OffsetData.Source.PluginSet)source2;
                OffsetProvider offsetProvider = affectedProvider = null;
            }
        }
        if (affectedProvider == null) {
            return null;
        }
        OffsetProvider reloadedProvider = this.core.getProviderConfig().getAllOffsetProviderConfigs().get(affectedProvider.name);
        if (reloadedProvider != null) {
            return reloadedProvider;
        }
        return affectedProvider;
    }

    private record PlayerOffsetData(OffsetData previousOffset, OffsetData currentOffset, @Nullable OffsetData nextOffset) {
    }
}

