/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.CoordinateOffsetPermission;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetData;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.config.OffsetProviderOverrideConfig;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.geysermc.geyser.api.GeyserApi;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OffsetFactory {
    private final CoordinateOffsetCore core;

    OffsetFactory(CoordinateOffsetCore core) {
        this.core = core;
    }

    OffsetData createOffset(OffsetProviderContext context) {
        OffsetProvider provider = null;
        if (OffsetFactory.canBypassByPermission(context.player())) {
            return new OffsetData(Offset.ZERO, new OffsetData.Source.PermissionBypass(), context);
        }
        if (this.isBedrockPlayerAndLogOnJoin(context)) {
            return new OffsetData(Offset.ZERO, new OffsetData.Source.BedrockBypass(), context);
        }
        Integer overrideRuleIndex = null;
        if (provider == null) {
            for (int i = 0; i < this.core.getProviderConfig().getOffsetProviderOverrides().size(); ++i) {
                OffsetProviderOverrideConfig override = this.core.getProviderConfig().getOffsetProviderOverrides().get(i);
                if (!override.appliesTo(context)) continue;
                overrideRuleIndex = i + 1;
                provider = override.getOffsetProvider();
                break;
            }
        }
        if (provider == null) {
            provider = this.core.getProviderConfig().getDefaultOffsetProviderConfig();
        }
        Offset offset = provider.provideOffset(context);
        FixedOffset fixed = this.fixOffsetVerbosely(offset, new OffsetData.Source.Provider(provider, overrideRuleIndex), context);
        return new OffsetData(fixed, new OffsetData.Source.Provider(provider, overrideRuleIndex), context);
    }

    public OffsetData createSpecificOffset(Offset offset, OffsetData.Source source, OffsetProviderContext context) {
        if (this.isBedrockPlayerAndLogOnJoin(context)) {
            return new OffsetData(Offset.ZERO, new OffsetData.Source.BedrockBypass(), context);
        }
        FixedOffset fixed = this.fixOffsetVerbosely(offset, source, context);
        return new OffsetData(fixed, source, context);
    }

    private FixedOffset fixOffsetVerbosely(Offset offset, OffsetData.Source source, OffsetProviderContext context) {
        Offset offset2 = offset;
        Objects.requireNonNull(offset2);
        Offset offset3 = offset2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FixedOffset.class, ScalableOffset.class}, (Object)offset3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                FixedOffset f;
                yield f = (FixedOffset)offset3;
            }
            case 1 -> {
                ScalableOffset s = (ScalableOffset)offset3;
                double scale = context.playerLocation().getWorld().getCoordinateScale();
                if (offset.isZero() || scale == 1.0 || !this.core.getConfig().getVerbose()) {
                    yield s.scaleDownBy(scale);
                }
                OffsetData.Source v2 = source;
                Objects.requireNonNull(v2);
                OffsetData.Source var11_9 = v2;
                int var12_10 = 0;
                Object v3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffsetData.Source.SetCommand.class, OffsetData.Source.Provider.class, OffsetData.Source.BedrockBypass.class, OffsetData.Source.PermissionBypass.class, OffsetData.Source.PluginSet.class}, (Object)var11_9, var12_10)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        OffsetData.Source.SetCommand cmd = (OffsetData.Source.SetCommand)var11_9;
                        cmd.command().warnScaling(context.player(), scale);
                        yield "Command from " + cmd.command().getCommandSender().name() + ": ";
                    }
                    case 1 -> {
                        OffsetData.Source.Provider provider = (OffsetData.Source.Provider)var11_9;
                        yield "Provider \"" + provider.provider().name + "\": ";
                    }
                    case 2 -> {
                        OffsetData.Source.BedrockBypass ignored = (OffsetData.Source.BedrockBypass)var11_9;
                        yield "";
                    }
                    case 3 -> {
                        OffsetData.Source.PermissionBypass ignored = (OffsetData.Source.PermissionBypass)var11_9;
                        yield "";
                    }
                    case 4 -> {
                        OffsetData.Source.PluginSet ignored = (OffsetData.Source.PluginSet)var11_9;
                        yield "";
                    }
                };
                String prefix = v3;
                this.core.getLogger().info(prefix + "Scaling offset " + String.valueOf(s) + " by " + scale + " to match coordinate scale of world \"" + context.playerLocation().getWorld().getName() + "\"");
                yield s.scaleDownBy(scale);
            }
        };
    }

    public static boolean canBypassByPermission(OffsetPlayer player) {
        return CoordinateOffsetCore.get().getConfig().getBypassByPermission() && player.hasPermission(CoordinateOffsetPermission.BYPASS.node);
    }

    private boolean isBedrockPlayerAndLogOnJoin(OffsetProviderContext context) {
        try {
            if (GeyserApi.api().isBedrockPlayer(context.player().getUuid())) {
                if (context.reason() == OffsetProviderContext.ProvideReason.JOIN) {
                    this.core.getLogger().warning("Coordinate offsets are disabled for Bedrock player " + context.player().getName() + ". (Give permission coordinateoffset.bypass to disable offsets and hide this warning)");
                }
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }
}

