/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider.util;

import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.Map;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record ResetConfig(@Nullable Boolean resetOnDeath, @Nullable Boolean resetOnWorldChange, @Nullable Boolean resetOnDistantTeleport) {
    public boolean resetOn(OffsetProviderContext.ProvideReason reason) {
        switch (reason) {
            case DEATH_RESPAWN: {
                return Boolean.TRUE.equals(this.resetOnDeath);
            }
            case WORLD_CHANGE: {
                return Boolean.TRUE.equals(this.resetOnWorldChange);
            }
            case DISTANT_TELEPORT: {
                return Boolean.TRUE.equals(this.resetOnDistantTeleport);
            }
        }
        return false;
    }

    public void serializeTo(SequencedMap<String, Object> map) {
        if (this.resetOnDeath != null) {
            map.put("resetOnDeath", this.resetOnDeath);
        }
        if (this.resetOnWorldChange != null) {
            map.put("resetOnWorldChange", this.resetOnWorldChange);
        }
        if (this.resetOnDistantTeleport != null) {
            map.put("resetOnDistantTeleport", this.resetOnDistantTeleport);
        }
    }

    public static @Nullable ResetConfig deserialize(Map<String, ?> providerConfig) throws IllegalArgumentException {
        boolean anySet = false;
        Boolean resetOnDeath = null;
        if (providerConfig.get("resetOnDeath") != null) {
            Object obj = providerConfig.get("resetOnDeath");
            if (!(obj instanceof Boolean)) {
                throw new IllegalArgumentException("resetOnDeath must be a boolean");
            }
            Boolean b = (Boolean)obj;
            resetOnDeath = b;
            anySet = true;
        }
        Boolean resetOnWorldChange = null;
        if (providerConfig.get("resetOnWorldChange") != null) {
            Object obj = providerConfig.get("resetOnWorldChange");
            if (!(obj instanceof Boolean)) {
                throw new IllegalArgumentException("resetOnWorldChange must be a boolean");
            }
            Boolean b = (Boolean)obj;
            resetOnWorldChange = b;
            anySet = true;
        }
        Boolean resetOnDistantTeleport = null;
        if (providerConfig.get("resetOnDistantTeleport") != null) {
            Object obj = providerConfig.get("resetOnDistantTeleport");
            if (!(obj instanceof Boolean)) {
                throw new IllegalArgumentException("resetOnDistantTeleport must be a boolean");
            }
            Boolean b = (Boolean)obj;
            resetOnDistantTeleport = b;
            anySet = true;
        }
        if (!anySet) {
            return null;
        }
        return new ResetConfig(resetOnDeath, resetOnWorldChange, resetOnDistantTeleport);
    }
}

