/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider.util;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.provider.util.PlayerOffsetPersistence;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed interface PerWorldOffsetStore {
    public @Nullable Offset get(OffsetPlayer var1, String var2);

    public void put(OffsetPlayer var1, String var2, Offset var3);

    public void reset(OffsetPlayer var1);

    public void reset(UUID var1);

    public static final class Persistent
    implements PerWorldOffsetStore {
        private final PlayerOffsetPersistence.Key persistenceKey;

        public Persistent(PlayerOffsetPersistence.Key persistenceKey) {
            this.persistenceKey = persistenceKey;
        }

        @Override
        public @Nullable Offset get(OffsetPlayer player, String worldName) {
            return CoordinateOffsetCore.get().getAdapter().getPlayerOffsetPersistence().getPlayerOffset(player, this.persistenceKey, worldName);
        }

        @Override
        public void put(OffsetPlayer player, String worldName, Offset offset) {
            CoordinateOffsetCore.get().getAdapter().getPlayerOffsetPersistence().storePlayerOffset(player, this.persistenceKey, worldName, offset);
        }

        @Override
        public void reset(OffsetPlayer player) {
            CoordinateOffsetCore.get().getAdapter().getPlayerOffsetPersistence().clearPlayerOffsets(player.getUuid(), this.persistenceKey);
        }

        @Override
        public void reset(UUID playerUuid) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public static final class Cached
    implements PerWorldOffsetStore {
        private final Map<UUID, Map<String, Offset>> playerCache = new HashMap<UUID, Map<String, Offset>>();

        @Override
        public @Nullable Offset get(OffsetPlayer player, String worldName) {
            Map<String, Offset> map = this.playerCache.get(player.getUuid());
            if (map == null) {
                return null;
            }
            return map.get(worldName);
        }

        @Override
        public void put(OffsetPlayer player, String worldName, Offset offset) {
            if (!this.playerCache.containsKey(player.getUuid())) {
                this.playerCache.put(player.getUuid(), new HashMap());
            }
            this.playerCache.get(player.getUuid()).put(worldName, offset);
        }

        @Override
        public void reset(OffsetPlayer player) {
            this.playerCache.remove(player.getUuid());
        }

        @Override
        public void reset(UUID uuid) {
            this.playerCache.remove(uuid);
        }
    }
}

