/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.util.PerWorldOffsetStore;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import com.jtprince.coordinateoffset.provider.util.WorldAlignmentConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ZeroAtLocationOffsetProvider
extends OffsetProvider {
    @Nullable ResetConfig resetConfig;
    @Nullable WorldAlignmentConfig worldAlignmentConfig;
    private final PerWorldOffsetStore perWorldOffsetStore = new PerWorldOffsetStore.Cached();

    ZeroAtLocationOffsetProvider(String name) {
        super(name);
    }

    @Override
    public Offset provideOffset(OffsetProviderContext context) {
        Offset alignedWorldOffset;
        Offset offset;
        if (this.resetConfig != null && this.resetConfig.resetOn(context.reason())) {
            this.perWorldOffsetStore.reset(context.player());
        }
        if ((offset = this.perWorldOffsetStore.get(context.player(), context.worldName())) != null) {
            return offset;
        }
        WorldAlignmentConfig.QueryResult alignment = null;
        if (this.worldAlignmentConfig != null) {
            alignment = this.worldAlignmentConfig.findAlignment(context.worldName());
        }
        if (alignment != null && (alignedWorldOffset = this.perWorldOffsetStore.get(context.player(), alignment.targetWorldName())) != null) {
            offset = alignedWorldOffset.scale(alignment.rightShiftAmount());
            if (CoordinateOffsetCore.get().getConfig().getVerbose()) {
                Object scaleStr = alignment.rightShiftAmount() == 0 ? "." : (alignment.rightShiftAmount() < 0 ? " (scaled up by " + (1 << -alignment.rightShiftAmount()) + ")." : " (scaled down by " + (1 << alignment.rightShiftAmount()) + ").");
                CoordinateOffsetCore.get().getLogger().info("Provider \"" + this.name + "\": Aligning new offset for world \"" + context.worldName() + "\" to offset from world \"" + alignment.targetWorldName() + "\"" + (String)scaleStr);
            }
        }
        if (offset == null) {
            OffsetLocation loc = context.playerLocation();
            int alignmentPower = 0;
            if (this.worldAlignmentConfig != null) {
                alignmentPower = this.worldAlignmentConfig.greatestPossibleRightShiftForWorld(context.worldName());
            }
            offset = Offset.align((int)loc.getX(), (int)loc.getZ(), alignmentPower);
        }
        this.perWorldOffsetStore.put(context.player(), context.worldName(), offset);
        return offset;
    }

    @Override
    public void onPlayerDisconnect(UUID playerUuid) {
        if (this.perWorldOffsetStore instanceof PerWorldOffsetStore.Cached) {
            this.perWorldOffsetStore.reset(playerUuid);
        }
    }

    public @Nullable ResetConfig getResetConfig() {
        return this.resetConfig;
    }

    @Override
    public SequencedMap<String, ?> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.resetConfig != null) {
            this.resetConfig.serializeTo(map);
        }
        if (this.worldAlignmentConfig != null) {
            this.worldAlignmentConfig.serializeTo(map);
        }
        return map;
    }

    public static ZeroAtLocationOffsetProvider deserialize(OffsetProviderConfig config) throws IllegalArgumentException {
        SequencedMap<String, Object> s = config.getConfigSection();
        ResetConfig resetConfig = ResetConfig.deserialize(s);
        WorldAlignmentConfig worldAlignment = null;
        if (s.containsKey("worldAlignment")) {
            Object v = s.get("worldAlignment");
            if (!(v instanceof List)) {
                throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + ": Field `worldAlignment` for ZeroAtLocationOffsetProvider is not a list.");
            }
            List worldAlignmentList = (List)v;
            worldAlignment = WorldAlignmentConfig.deserialize(worldAlignmentList.stream().map(Object::toString).toList());
        }
        ZeroAtLocationOffsetProvider provider = new ZeroAtLocationOffsetProvider(config.getUserDefinedProviderName());
        provider.resetConfig = resetConfig;
        provider.worldAlignmentConfig = worldAlignment;
        return provider;
    }
}

