/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.util.PerWorldOffsetStore;
import com.jtprince.coordinateoffset.provider.util.PlayerOffsetPersistence;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import com.jtprince.coordinateoffset.provider.util.WorldAlignmentConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RandomOffsetProvider
extends OffsetProvider {
    public static final String PERSISTENCE_KEY_CLASS_KEY = "random-persistence";
    public static final String DEFAULT_PERSISTENCE_KEY = "default";
    final int randomBound;
    @Nullable ResetConfig resetConfig;
    @Nullable WorldAlignmentConfig worldAlignmentConfig;
    @Nullable Boolean isPersistentConfig;
    @Nullable String persistenceKeyConfig;
    private final PerWorldOffsetStore perWorldOffsetStore;

    RandomOffsetProvider(String name, int randomBound,  @Nullable PlayerOffsetPersistence.Key persistenceKey) {
        super(name);
        this.randomBound = randomBound;
        this.perWorldOffsetStore = persistenceKey != null ? new PerWorldOffsetStore.Persistent(persistenceKey) : new PerWorldOffsetStore.Cached();
    }

    @Override
    public Offset provideOffset(OffsetProviderContext context) {
        Offset alignedWorldOffset;
        Offset offset;
        if (this.resetConfig != null && this.resetConfig.resetOn(context.reason())) {
            this.perWorldOffsetStore.reset(context.player());
        }
        if ((offset = this.perWorldOffsetStore.get(context.player(), context.worldName())) != null) {
            return offset;
        }
        WorldAlignmentConfig.QueryResult alignment = null;
        if (this.worldAlignmentConfig != null) {
            alignment = this.worldAlignmentConfig.findAlignment(context.worldName());
        }
        if (alignment != null && (alignedWorldOffset = this.perWorldOffsetStore.get(context.player(), alignment.targetWorldName())) != null) {
            offset = alignedWorldOffset.scale(alignment.rightShiftAmount());
            if (CoordinateOffsetCore.get().getConfig().getVerbose()) {
                Object scaleStr = alignment.rightShiftAmount() == 0 ? "." : (alignment.rightShiftAmount() < 0 ? " (scaled up by " + (1 << -alignment.rightShiftAmount()) + ")." : " (scaled down by " + (1 << alignment.rightShiftAmount()) + ").");
                CoordinateOffsetCore.get().getLogger().info("Provider \"" + this.name + "\": Aligning new offset for world \"" + context.worldName() + "\" to offset from world \"" + alignment.targetWorldName() + "\"" + (String)scaleStr);
            }
        }
        if (offset == null) {
            offset = Offset.random(this.randomBound);
        }
        this.perWorldOffsetStore.put(context.player(), context.worldName(), offset);
        return offset;
    }

    @Override
    public void onPlayerDisconnect(UUID playerUuid) {
        if (this.perWorldOffsetStore instanceof PerWorldOffsetStore.Cached) {
            this.perWorldOffsetStore.reset(playerUuid);
        }
    }

    public boolean isPersistent() {
        return this.perWorldOffsetStore instanceof PerWorldOffsetStore.Persistent;
    }

    public @Nullable ResetConfig getResetConfig() {
        return this.resetConfig;
    }

    public @Nullable WorldAlignmentConfig getWorldAlignmentConfig() {
        return this.worldAlignmentConfig;
    }

    @Override
    public SequencedMap<String, ?> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("randomBound", Long.valueOf(this.randomBound));
        if (this.resetConfig != null) {
            this.resetConfig.serializeTo(map);
        }
        if (this.isPersistentConfig != null) {
            map.put("persistent", this.isPersistentConfig);
        }
        if (this.persistenceKeyConfig != null) {
            map.put("persistenceKey", this.persistenceKeyConfig);
        }
        if (this.worldAlignmentConfig != null) {
            this.worldAlignmentConfig.serializeTo(map);
        }
        return map;
    }

    public static RandomOffsetProvider deserialize(OffsetProviderConfig config) throws IllegalArgumentException {
        Object v;
        SequencedMap<String, Object> s = config.getConfigSection();
        if (!s.containsKey("randomBound") || !((v = s.get("randomBound")) instanceof Number)) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + ": Required key `randomBound` for RandomOffsetProvider is missing or invalid.");
        }
        Number randomBoundNum = (Number)v;
        int randomBound = randomBoundNum.intValue();
        ResetConfig resetConfig = ResetConfig.deserialize(s);
        Boolean persistent = null;
        if (s.containsKey("persistent")) {
            if (!(s.get("persistent") instanceof Boolean)) {
                throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + ": Field `persistent` for RandomOffsetProvider is not a boolean.");
            }
            persistent = (Boolean)s.get("persistent");
        }
        String persistenceKeyConfig = null;
        if (s.containsKey("persistenceKey")) {
            persistenceKeyConfig = s.get("persistenceKey").toString();
        }
        PlayerOffsetPersistence.Key persistenceKey = null;
        if (persistent != null && persistent.booleanValue()) {
            persistenceKey = new PlayerOffsetPersistence.Key(PERSISTENCE_KEY_CLASS_KEY, persistenceKeyConfig != null ? persistenceKeyConfig : DEFAULT_PERSISTENCE_KEY);
        }
        WorldAlignmentConfig worldAlignment = null;
        if (s.containsKey("worldAlignment")) {
            Object v2 = s.get("worldAlignment");
            if (!(v2 instanceof List)) {
                throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + ": Field `worldAlignment` for RandomOffsetProvider is not a list.");
            }
            List worldAlignmentList = (List)v2;
            worldAlignment = WorldAlignmentConfig.deserialize(worldAlignmentList.stream().map(Object::toString).toList());
        }
        RandomOffsetProvider provider = new RandomOffsetProvider(config.getUserDefinedProviderName(), randomBound, persistenceKey);
        provider.resetConfig = resetConfig;
        provider.isPersistentConfig = persistent;
        provider.persistenceKeyConfig = persistenceKeyConfig;
        provider.worldAlignmentConfig = worldAlignment;
        return provider;
    }
}

