/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.provider.ConstantOffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.RandomOffsetProvider;
import com.jtprince.coordinateoffset.provider.ZeroAtLocationOffsetProvider;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import com.jtprince.coordinateoffset.provider.util.WorldAlignmentConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultOffsetProviders {
    static final ConstantOffsetProvider CONSTANT_1024 = new ConstantOffsetProvider("constant", new Offset(1024, 1024), Map.of("world_nether", 0.125));
    static final ConstantOffsetProvider CONSTANT_DISABLED = new ConstantOffsetProvider("disabled", Offset.ZERO, null);
    static final RandomOffsetProvider RANDOM = new RandomOffsetProvider("random", 100000, null);
    static final ZeroAtLocationOffsetProvider ZERO_LOC;
    public static SequencedMap<String, OffsetProvider> PROVIDERS;

    static {
        DefaultOffsetProviders.RANDOM.resetConfig = new ResetConfig(false, false, null);
        DefaultOffsetProviders.RANDOM.isPersistentConfig = false;
        DefaultOffsetProviders.RANDOM.persistenceKeyConfig = "default";
        DefaultOffsetProviders.RANDOM.worldAlignmentConfig = WorldAlignmentConfig.DEFAULT;
        ZERO_LOC = new ZeroAtLocationOffsetProvider("zeroAtLocation");
        DefaultOffsetProviders.ZERO_LOC.resetConfig = new ResetConfig(false, false, null);
        DefaultOffsetProviders.ZERO_LOC.worldAlignmentConfig = WorldAlignmentConfig.DEFAULT;
        PROVIDERS = new LinkedHashMap<String, OffsetProvider>();
        PROVIDERS.put(DefaultOffsetProviders.CONSTANT_1024.name, CONSTANT_1024);
        PROVIDERS.put(DefaultOffsetProviders.CONSTANT_DISABLED.name, CONSTANT_DISABLED);
        PROVIDERS.put(DefaultOffsetProviders.RANDOM.name, RANDOM);
        PROVIDERS.put(DefaultOffsetProviders.RANDOM.name, RANDOM);
        PROVIDERS.put(DefaultOffsetProviders.ZERO_LOC.name, ZERO_LOC);
    }
}

