/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ConstantOffsetProvider
extends OffsetProvider {
    final Offset offset;
    final @Nullable Map<String, Double> worldScaling;

    ConstantOffsetProvider(String name, Offset offset, @Nullable Map<String, Double> worldScaling) {
        super(name);
        this.offset = offset;
        this.worldScaling = worldScaling;
    }

    @Override
    public Offset provideOffset(OffsetProviderContext context) {
        Double scaling;
        if (this.worldScaling != null && (scaling = this.worldScaling.get(context.worldName())) != null) {
            return this.offset.scaleByDouble(scaling);
        }
        return this.offset;
    }

    @Override
    public SequencedMap<String, ?> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("offsetX", Long.valueOf(this.offset.x()));
        map.put("offsetZ", Long.valueOf(this.offset.z()));
        if (this.worldScaling != null) {
            map.put("worldScaling", this.worldScaling);
        }
        return map;
    }

    public static ConstantOffsetProvider deserialize(OffsetProviderConfig config) throws IllegalArgumentException {
        Object v;
        Object v2;
        SequencedMap<String, Object> s = config.getConfigSection();
        if (!s.containsKey("offsetX") || !((v2 = s.get("offsetX")) instanceof Number)) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": Required key `offsetX` for ConstantOffsetProvider is missing or invalid.");
        }
        Number offsetXNum = (Number)v2;
        if (!s.containsKey("offsetZ") || !((v = s.get("offsetZ")) instanceof Number)) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": Required key `offsetZ` for ConstantOffsetProvider is missing or invalid.");
        }
        Number offsetZNum = (Number)v;
        int offsetX = offsetXNum.intValue();
        int offsetZ = offsetZNum.intValue();
        if (Math.abs(offsetX) > OffsetProvider.OFFSET_MAX) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": `offsetX` value " + offsetX + " is too large! (Max 30M)");
        }
        if (Math.abs(offsetZ) > OffsetProvider.OFFSET_MAX) {
            throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": `offsetZ` value " + offsetZ + " is too large! (Max 30M)");
        }
        HashMap<String, Double> worldScaling = null;
        if (s.containsKey("worldScaling")) {
            Object object = s.get("worldScaling");
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": `worldScaling` is not a map.");
            }
            Map worldScalingMap = (Map)object;
            worldScaling = new HashMap<String, Double>();
            for (Map.Entry entry : worldScalingMap.entrySet()) {
                String worldName = entry.getKey().toString();
                Object v3 = entry.getValue();
                if (!(v3 instanceof Number)) {
                    throw new IllegalArgumentException("Provider \"" + config.getUserDefinedProviderName() + "\": `worldScaling` value " + String.valueOf(entry.getValue()) + " for world \"" + worldName + "\" is not a number.");
                }
                Number scalingNum = (Number)v3;
                worldScaling.put(worldName, scalingNum.doubleValue());
            }
        }
        return new ConstantOffsetProvider(config.getUserDefinedProviderName(), new Offset(offsetX, offsetZ), worldScaling);
    }
}

