/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.lib.com.jeff_media.morepersistentdatatypes.DataType;
import com.jtprince.coordinateoffset.lib.com.jeff_media.morepersistentdatatypes.datatypes.GenericDataType;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.jtprince.coordinateoffset.provider.util.PlayerOffsetPersistence;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperPlayerOffsetPersistence
implements PlayerOffsetPersistence {
    private static final PersistentDataType<int[], Offset> PDT_OFFSET = new GenericDataType<int[], Offset>(DataType.INTEGER_ARRAY.getPrimitiveType(), Offset.class, PaperPlayerOffsetPersistence::fromPdt, PaperPlayerOffsetPersistence::toPdt);
    private static final PersistentDataType<PersistentDataContainer, Map<String, Offset>> PDT_WORLD_OFFSET_CONTAINER = DataType.asMap(DataType.STRING, PDT_OFFSET);
    private final CoordinateOffsetPaperPlugin plugin;

    public PaperPlayerOffsetPersistence(CoordinateOffsetPaperPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void storePlayerOffset(OffsetPlayer player, PlayerOffsetPersistence.Key persistenceKey, String worldName, Offset offset) {
        if (!(player instanceof PaperOffsetPlayer)) {
            throw new IllegalArgumentException("Player must be an instance of PaperOffsetPlayer");
        }
        PaperOffsetPlayer paperPlayer = (PaperOffsetPlayer)player;
        HashMap<String, Offset> map = (HashMap<String, Offset>)paperPlayer.getPlayer().getPersistentDataContainer().get(this.persistenceKeyToBukkitKey(persistenceKey), PDT_WORLD_OFFSET_CONTAINER);
        if (map == null) {
            map = new HashMap<String, Offset>();
        }
        map.put(worldName, offset);
        paperPlayer.getPlayer().getPersistentDataContainer().set(this.persistenceKeyToBukkitKey(persistenceKey), PDT_WORLD_OFFSET_CONTAINER, map);
    }

    @Override
    public void clearPlayerOffsets(UUID playerUuid, PlayerOffsetPersistence.Key persistenceKey) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
            this.plugin.getLogger().warning("Failed to clear persistent offset for " + offlinePlayer.getName() + " (" + String.valueOf(playerUuid) + ")");
            return;
        }
        player.getPersistentDataContainer().remove(this.persistenceKeyToBukkitKey(persistenceKey));
    }

    @Override
    public @Nullable Offset getPlayerOffset(OffsetPlayer player, PlayerOffsetPersistence.Key persistenceKey, String worldName) {
        if (!(player instanceof PaperOffsetPlayer)) {
            throw new IllegalArgumentException("Player must be an instance of PaperOffsetPlayer");
        }
        PaperOffsetPlayer paperPlayer = (PaperOffsetPlayer)player;
        Map map = (Map)paperPlayer.getPlayer().getPersistentDataContainer().get(this.persistenceKeyToBukkitKey(persistenceKey), PDT_WORLD_OFFSET_CONTAINER);
        if (map == null) {
            return null;
        }
        return (Offset)map.get(worldName);
    }

    private static Offset fromPdt(int[] arr) {
        return new Offset(arr[0], arr[1]);
    }

    private static int[] toPdt(Offset offset) {
        return new int[]{offset.x(), offset.z()};
    }

    private NamespacedKey persistenceKeyToBukkitKey(PlayerOffsetPersistence.Key persistenceKey) {
        return new NamespacedKey((Plugin)this.plugin, persistenceKey.toString());
    }
}

