/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperLocation
implements OffsetLocation {
    private final Location location;

    public PaperLocation(Location location) {
        this.location = location;
    }

    @Override
    public @Nullable String getWorldName() {
        if (this.location.getWorld() == null) {
            return null;
        }
        return this.location.getWorld().getName();
    }

    @Override
    public double getX() {
        return this.location.getX();
    }

    @Override
    public double getY() {
        return this.location.getY();
    }

    @Override
    public double getZ() {
        return this.location.getZ();
    }

    @Override
    public OffsetLocation apply(Offset offset) {
        return new PaperLocation(this.location.clone().subtract((double)offset.x(), 0.0, (double)offset.z()));
    }

    @Override
    public OffsetLocation unapply(Offset offset) {
        return new PaperLocation(this.location.clone().add((double)offset.x(), 0.0, (double)offset.z()));
    }

    @Override
    public Object getPlatformLocationObject() {
        return this.location;
    }

    public String toString() {
        return this.location.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperLocation)) return false;
        PaperLocation p = (PaperLocation)obj;
        if (!this.location.equals((Object)p.location)) return false;
        return true;
    }
}

