/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

@NullMarked
public class PacketEventSequencer
implements Listener {
    private static final int DELAY_MS_MAX = 0;
    private static final Set<Class<? extends Event>> SEQUENCED_EVENTS = Set.of(PlayerJoinEvent.class, PlayerSpawnLocationEvent.class, PlayerRespawnEvent.class, PlayerTeleportEvent.class, PlayerChangedWorldEvent.class, PlayerPostRespawnEvent.class);
    private static final Set<PacketType.Play.Server> SEQUENCED_PACKETS = Set.of(PacketType.Play.Server.JOIN_GAME, PacketType.Play.Server.RESPAWN, PacketType.Play.Server.SPAWN_POSITION, PacketType.Play.Server.PLAYER_POSITION_AND_LOOK, PacketType.Play.Server.UPDATE_VIEW_POSITION, PacketType.Play.Server.MAP_DATA, PacketType.Play.Server.MAP_CHUNK_BULK, PacketType.Play.Server.UNLOAD_CHUNK, PacketType.Play.Server.INITIALIZE_WORLD_BORDER, PacketType.Play.Server.WORLD_BORDER_CENTER, PacketType.Play.Server.WORLD_BORDER, PacketType.Play.Server.WORLD_BORDER_LERP_SIZE, PacketType.Play.Server.WORLD_BORDER_SIZE, PacketType.Play.Server.WORLD_BORDER_WARNING_REACH, PacketType.Play.Server.WORLD_BORDER_WARNING_DELAY);
    private final JavaPlugin plugin;
    private final Random random = new Random();
    private @Nullable PacketListener packetListener;

    public PacketEventSequencer(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void install() {
        for (Class<? extends Event> clazz : SEQUENCED_EVENTS) {
            Bukkit.getPluginManager().registerEvent(clazz, (Listener)this, EventPriority.NORMAL, (listener, event) -> this.onEvent(event), (Plugin)this.plugin);
        }
        this.packetListener = new PacketListener();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.packetListener);
    }

    private void onEvent(Event event) {
        this.delayAndLog("EVT", event.getEventName());
    }

    private void delayAndLog(String type, String message) {
        this.plugin.getLogger().info(String.format("[%s] [Thread %03d] %s", type, Thread.currentThread().threadId(), message));
    }

    private class PacketListener
    extends PacketListenerAbstract {
        PacketListener() {
            super(PacketListenerPriority.MONITOR);
        }

        public void onPacketSend(PacketSendEvent event) {
            if (SEQUENCED_PACKETS.contains(event.getPacketType())) {
                PacketEventSequencer.this.delayAndLog("PKT", event.getPacketType().getName());
            }
        }
    }
}

