/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.CoordinateOffsetPermission;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.Nullable;

public class OffsetCommand {
    private static final Set<CoordinateOffsetPermission> ROOT_COMMAND_PERMS = Set.of(CoordinateOffsetPermission.QUERY_SELF, CoordinateOffsetPermission.QUERY_OTHERS, CoordinateOffsetPermission.RELOAD);
    private @Nullable CoordinateOffsetPaperPlugin plugin;

    public void registerCommands(CoordinateOffsetPaperPlugin plugin) {
        this.plugin = plugin;
        LiteralArgumentBuilder root = Commands.literal((String)"offset");
        ((LiteralArgumentBuilder)root.requires(sender -> this.pluginEnabled() && ROOT_COMMAND_PERMS.stream().anyMatch(p -> sender.getSender().hasPermission(p.node)))).executes(this::querySelf);
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.QUERY_SELF.node) || sender.getSender().hasPermission(CoordinateOffsetPermission.QUERY_OTHERS.node))).executes(this::querySelf)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.QUERY_OTHERS.node))).executes(this::queryOther)));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.RELOAD.node))).executes(this::reload));
        plugin.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(root.build()));
    }

    private int reload(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        boolean success = CoordinateOffsetCore.get().reloadConfig();
        if (success) {
            sender.sendMessage(Component.text((String)"CoordinateOffset configuration reloaded from file.").color((TextColor)NamedTextColor.GREEN));
            sender.sendMessage(Component.text((String)"Changes to offset providers may not apply until players quit and rejoin.").color((TextColor)NamedTextColor.GRAY));
        } else {
            sender.sendMessage(Component.text((String)"Failed to reload CoordinateOffset configuration from file. Check the console for details.").color((TextColor)NamedTextColor.RED));
        }
        return 1;
    }

    private int querySelf(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).getSender().hasPermission(CoordinateOffsetPermission.QUERY_SELF.node)) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Bukkit.permissionMessage());
            return 0;
        }
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)Component.text((String)"You must be a player to query your own offset."));
            return 0;
        }
        Player player = (Player)commandSender;
        Offset offset = CoordinateOffsetCore.get().getOffsetHolder().getOffset(new PaperOffsetPlayer(player));
        if (offset.equals(Offset.ZERO)) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Component.text((String)"You have no coordinate offset applied. The coordinates you see are the real coordinates of the world.").color((TextColor)NamedTextColor.GREEN));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(((TextComponent)Component.text((String)"Your coordinate offset is: ").append(this.formatOffset(offset))).color((TextColor)NamedTextColor.GRAY));
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(((TextComponent)Component.text((String)"Your real coordinates are: ").append(this.formatLocation(player.getLocation()))).color((TextColor)NamedTextColor.GRAY));
        return 1;
    }

    private int queryOther(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
        Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
        if (target == null) {
            return 0;
        }
        Offset offset = CoordinateOffsetCore.get().getOffsetHolder().getOffset(new PaperOffsetPlayer(target));
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)target.getName()).color((TextColor)NamedTextColor.BLUE))).append((Component)Component.text((String)"'s coordinate offset is: "))).append(this.formatOffset(offset))).color((TextColor)NamedTextColor.GRAY));
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)target.getName()).color((TextColor)NamedTextColor.BLUE))).append((Component)Component.text((String)"'s real coordinates are: "))).append(this.formatLocation(target.getLocation()))).color((TextColor)NamedTextColor.GRAY));
        return 1;
    }

    private Component formatOffset(Offset offset) {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[x=").append(Component.text((int)offset.x()).color((TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)", z="))).append(Component.text((int)offset.z()).color((TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"]"))).color((TextColor)NamedTextColor.DARK_AQUA);
    }

    private Component formatLocation(Location location) {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[x=").append(Component.text((int)((int)location.getX())).color((TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)", y="))).append(Component.text((int)((int)location.getY())).color((TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)", z="))).append(Component.text((int)((int)location.getZ())).color((TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"]"))).color((TextColor)NamedTextColor.LIGHT_PURPLE);
    }

    private boolean pluginEnabled() {
        return this.plugin != null && this.plugin.isEnabled();
    }
}

