/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.lib.org.bstats.bukkit.Metrics;
import com.jtprince.coordinateoffset.lib.org.bstats.charts.DrilldownPie;
import com.jtprince.coordinateoffset.lib.org.bstats.charts.SimplePie;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.provider.ConstantOffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.RandomOffsetProvider;
import com.jtprince.coordinateoffset.provider.ZeroAtLocationOffsetProvider;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class MetricsWrapper {
    private static final int BSTATS_PLUGIN_METRICS_ID = 19988;

    public static void reportMetrics(CoordinateOffsetPaperPlugin plugin) {
        Metrics metrics = new Metrics(plugin, 19988);
        CoordinateOffsetCore core = CoordinateOffsetCore.get();
        metrics.addCustomChart(new DrilldownPie("default_offset_provider", () -> {
            HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
            OffsetProvider defaultProvider = core.getProviderConfig().getDefaultOffsetProviderConfig();
            if (defaultProvider instanceof ConstantOffsetProvider) {
                result.put("ConstantOffsetProvider", Map.of("ConstantOffsetProvider", 1));
            } else if (defaultProvider instanceof RandomOffsetProvider) {
                RandomOffsetProvider randomOffsetProvider = (RandomOffsetProvider)defaultProvider;
                StringBuilder sb = new StringBuilder();
                sb.append(randomOffsetProvider.isPersistent() ? "Persistent" : "Not Persistent");
                sb.append(" | Reset ");
                ResetConfig rc = randomOffsetProvider.getResetConfig();
                sb.append(rc != null && rc.resetOn(OffsetProviderContext.ProvideReason.DEATH_RESPAWN) ? "D" : "x");
                sb.append(rc != null && rc.resetOn(OffsetProviderContext.ProvideReason.WORLD_CHANGE) ? "W" : "x");
                sb.append(rc != null && rc.resetOn(OffsetProviderContext.ProvideReason.DISTANT_TELEPORT) ? "T" : "x");
                result.put("RandomOffsetProvider", Map.of(sb.toString(), 1));
            } else if (defaultProvider instanceof ZeroAtLocationOffsetProvider) {
                ZeroAtLocationOffsetProvider zeroAtLocationOffsetProvider = (ZeroAtLocationOffsetProvider)defaultProvider;
                StringBuilder sb = new StringBuilder();
                sb.append("Reset ");
                ResetConfig rc = zeroAtLocationOffsetProvider.getResetConfig();
                sb.append(rc != null && rc.resetOn(OffsetProviderContext.ProvideReason.DEATH_RESPAWN) ? "D" : "x");
                sb.append(rc != null && rc.resetOn(OffsetProviderContext.ProvideReason.WORLD_CHANGE) ? "W" : "x");
                sb.append(rc != null && rc.resetOn(OffsetProviderContext.ProvideReason.DISTANT_TELEPORT) ? "T" : "x");
                result.put("ZeroAtLocationOffsetProvider", Map.of(sb.toString(), 1));
            } else {
                result.put("Custom Provider", Map.of("Unknown Offset Provider", 1));
            }
            return result;
        }));
        metrics.addCustomChart(new SimplePie("world_border_obfuscation", () -> MetricsWrapper.enabledDisabledStr(core.getConfig().getObfuscateWorldBorder())));
        metrics.addCustomChart(new SimplePie("debug_packet_obfuscation", () -> MetricsWrapper.enabledDisabledStr(core.getConfig().getObfuscateDebugPropertySubscriptions())));
        metrics.addCustomChart(new SimplePie("unsafe_reset_on_teleport", () -> MetricsWrapper.enabledDisabledStr(core.getConfig().getUnsafeResetOnDistantTeleport())));
        metrics.addCustomChart(new SimplePie("fix_collision", () -> {
            boolean enabled = false;
            StringBuilder sb = new StringBuilder();
            if (core.getConfig().getFixCollisionBamboo()) {
                enabled = true;
                sb.append("B");
            } else {
                sb.append("x");
            }
            if (core.getConfig().getFixCollisionDripstone()) {
                enabled = true;
                sb.append("D");
            } else {
                sb.append("x");
            }
            if (enabled) {
                return "enabled (" + String.valueOf(sb) + ")";
            }
            return "disabled";
        }));
        metrics.addCustomChart(new SimplePie("verbose", () -> MetricsWrapper.enabledDisabledStr(core.getConfig().getVerbose())));
        metrics.addCustomChart(new SimplePie("offset_provider_override_count", () -> String.valueOf(core.getProviderConfig().getOffsetProviderOverrides().size())));
    }

    private static String enabledDisabledStr(boolean enabled) {
        return enabled ? "enabled" : "disabled";
    }
}

