/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.WorldBorderObfuscator;
import com.jtprince.coordinateoffset.paper.adapter.PaperLocation;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

@NullMarked
class BukkitEventListener
implements Listener {
    private final CoordinateOffsetPaperPlugin plugin;
    private final CoordinateOffsetCore core;
    private final WorldBorderObfuscator worldBorderObfuscator;
    private boolean isJoinEventFiredBeforeFirstPlayPacket;

    BukkitEventListener(CoordinateOffsetPaperPlugin plugin, CoordinateOffsetCore core, WorldBorderObfuscator worldBorderObfuscator) {
        this.plugin = plugin;
        this.core = core;
        this.worldBorderObfuscator = worldBorderObfuscator;
    }

    public void registerListeners() {
        this.isJoinEventFiredBeforeFirstPlayPacket = this.is1_21_9OrGreater();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        if (!this.isJoinEventFiredBeforeFirstPlayPacket) {
            Bukkit.getPluginManager().registerEvents((Listener)new OldSpawnLocationListener(), (Plugin)this.plugin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerLoad(ServerLoadEvent event) {
        this.plugin.onAllPluginsEnabled();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.isJoinEventFiredBeforeFirstPlayPacket) {
            return;
        }
        PaperOffsetPlayer player = new PaperOffsetPlayer(event.getPlayer());
        this.core.getOffsetHolder().generateNextOffset(new OffsetProviderContext(player, event.getPlayer().getWorld().getName(), new PaperLocation(event.getPlayer().getLocation()), OffsetProviderContext.ProvideReason.JOIN));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        OffsetProviderContext.ProvideReason reason = OffsetProviderContext.ProvideReason.DEATH_RESPAWN;
        try {
            if (event.getRespawnReason() != PlayerRespawnEvent.RespawnReason.DEATH) {
                reason = OffsetProviderContext.ProvideReason.WORLD_CHANGE;
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            try {
                if (event.getRespawnFlags().contains(PlayerRespawnEvent.RespawnFlag.END_PORTAL)) {
                    reason = OffsetProviderContext.ProvideReason.WORLD_CHANGE;
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodError e2) {
                this.plugin.getLogger().fine("No supported method for determining respawn reason.");
            }
        }
        this.core.getOffsetHolder().generateNextOffset(new OffsetProviderContext(new PaperOffsetPlayer(event.getPlayer()), event.getRespawnLocation().getWorld().getName(), new PaperLocation(event.getRespawnLocation()), reason));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        PaperOffsetPlayer player = new PaperOffsetPlayer(event.getPlayer());
        OffsetProviderContext.ProvideReason reason = null;
        if (event.getFrom().getWorld() != Objects.requireNonNull(event.getTo()).getWorld()) {
            reason = OffsetProviderContext.ProvideReason.WORLD_CHANGE;
        } else if (event.getFrom().distanceSquared(event.getTo()) > (double)this.getMinimumTeleportDistanceSquared(event.getTo().getWorld()) && this.core.getConfig().getUnsafeResetOnDistantTeleport()) {
            reason = OffsetProviderContext.ProvideReason.DISTANT_TELEPORT;
        }
        if (reason == null) {
            return;
        }
        this.core.getOffsetHolder().generateNextOffset(new OffsetProviderContext(player, event.getTo().getWorld().getName(), new PaperLocation(event.getTo()), reason));
        this.worldBorderObfuscator.tryUpdatePlayerBorders(event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.worldBorderObfuscator.tryUpdatePlayerBorders(event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        for (OffsetProvider provider : this.core.getProviderConfig().getAllOffsetProviderConfigs().values()) {
            provider.onPlayerQuit(new PaperOffsetPlayer(event.getPlayer()));
        }
    }

    private int getMinimumTeleportDistanceSquared(World world) {
        int viewDistance = world.getViewDistance();
        int minimumBlocks = (viewDistance + 1) * 2 * 16;
        return minimumBlocks * minimumBlocks;
    }

    private boolean is1_21_9OrGreater() {
        String mcVersion = Bukkit.getMinecraftVersion();
        String warningMessage = "Could not parse Minecraft version \"" + mcVersion + "\". Behaving as though Minecraft version is 1.21.9 or above. If you see bugs, please mention this message to the plugin author.";
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+).*");
        Matcher m = pattern.matcher(mcVersion);
        if (!m.matches()) {
            this.core.getLogger().warning(warningMessage);
            return true;
        }
        try {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            int patch = Integer.parseInt(m.group(3));
            return major > 1 || major == 1 && minor > 21 || major == 1 && minor == 21 && patch >= 9;
        }
        catch (NumberFormatException e) {
            this.core.getLogger().warning(warningMessage);
            return true;
        }
    }

    private class OldSpawnLocationListener
    implements Listener {
        private OldSpawnLocationListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onSpawnLocation(PlayerSpawnLocationEvent event) {
            PaperOffsetPlayer player = new PaperOffsetPlayer(event.getPlayer());
            BukkitEventListener.this.core.getOffsetHolder().generateNextOffset(new OffsetProviderContext(player, event.getSpawnLocation().getWorld().getName(), new PaperLocation(event.getSpawnLocation()), OffsetProviderContext.ProvideReason.JOIN));
        }
    }
}

