/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter;

import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.github.retrooper.packetevents.protocol.world.chunk.Column;
import com.github.retrooper.packetevents.protocol.world.chunk.HeightmapType;
import com.github.retrooper.packetevents.protocol.world.chunk.TileEntity;
import com.jtprince.coordinateoffset.Offset;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OffsettedColumn
extends Column {
    private final Column inner;
    private final Offset offset;
    private final User user;
    private static final BaseChunk[] emptyChunkList = new BaseChunk[0];

    public OffsettedColumn(Column column, Offset offset, User user) {
        super(0, 0, false, emptyChunkList, null);
        this.inner = column;
        this.offset = offset;
        this.user = user;
    }

    public int getX() {
        return this.inner.getX() - this.offset.chunkX();
    }

    public int getZ() {
        return this.inner.getZ() - this.offset.chunkZ();
    }

    public boolean isFullChunk() {
        return this.inner.isFullChunk();
    }

    public BaseChunk[] getChunks() {
        return this.inner.getChunks();
    }

    public TileEntity[] getTileEntities() {
        if (this.user.getClientVersion().isOlderThan(ClientVersion.V_1_18)) {
            TileEntity[] entities;
            for (TileEntity entity : entities = this.inner.getTileEntities()) {
                entity.setX(entity.getX() - this.offset.x());
                entity.setZ(entity.getZ() - this.offset.z());
            }
            return entities;
        }
        return this.inner.getTileEntities();
    }

    public boolean hasHeightMaps() {
        return this.inner.hasHeightMaps();
    }

    public NBTCompound getHeightMaps() {
        return this.inner.getHeightMaps();
    }

    public Map<HeightmapType, long[]> getHeightmaps() {
        return this.inner.getHeightmaps();
    }

    public boolean hasBiomeData() {
        return this.inner.hasBiomeData();
    }

    public int[] getBiomeDataInts() {
        return this.inner.getBiomeDataInts();
    }

    public byte[] getBiomeDataBytes() {
        return this.inner.getBiomeDataBytes();
    }
}

