/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.config;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfigBase;
import com.jtprince.coordinateoffset.config.CoordinateOffsetProviderConfig;
import com.jtprince.coordinateoffset.config.OffsetProviderListSerializer;
import com.jtprince.coordinateoffset.config.OffsetProviderOverrideConfig;
import com.jtprince.coordinateoffset.config.OffsetProviderOverrideConfigImpl;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.Comment;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.Configuration;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.SerializeWith;
import com.jtprince.coordinateoffset.provider.DefaultOffsetProviders;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import java.util.List;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Configuration
public class CoordinateOffsetConfigFull
extends CoordinateOffsetConfigBase
implements CoordinateOffsetProviderConfig {
    @Comment(value={"", "############################################################################ #", "####################### Offset Provider Configuration ###################### #", "############################################################################ #", "", "Specify the method used to apply coordinate offsets to players.", "Options are any key under `offsetProviders` below (e.g. constant, random...)"})
    String defaultOffsetProvider = "random";
    @Comment(value={"", "List of overrides to the default offset provider. The first item has the", "  highest priority. `provider` is a required key. Optional keys are", "  `world`, `playerUuid`, and `permission` which, if present, must ALL match", "  for the override to apply. Example:", "offsetProviderOverrides:", " - provider: constant", "   world: world_nether", "   permission: coordinateoffset.provider.my_custom_permission", " - provider: zeroAtLocation", "   playerUuid: 00000000-0000-0000-0000-000000000000"})
    List<OffsetProviderOverrideConfigImpl> offsetProviderOverrides = List.of();
    @Comment(value={"", "Configuration for all available offset providers. Each provider must have a", "  unique key (e.g. \"constant\"), which is used in `defaultOffsetProvider` and", "  `offsetProviderOverrides`. You may add your own keys to define as many", "  providers as you need.", "See the configuration guide for details about which options are available for", "  each provider class.", "https://github.com/joshuaprince/CoordinateOffset/wiki/Configuration-Guide"})
    @SerializeWith(serializer=OffsetProviderListSerializer.class)
    SequencedMap<String, OffsetProvider> offsetProviders = DefaultOffsetProviders.PROVIDERS;

    @Override
    public OffsetProvider getDefaultOffsetProviderConfig() {
        return Objects.requireNonNull((OffsetProvider)this.offsetProviders.get(this.defaultOffsetProvider));
    }

    @Override
    public List<OffsetProviderOverrideConfig> getOffsetProviderOverrides() {
        return this.offsetProviderOverrides.stream().filter(o -> o.validate(this.offsetProviders, false)).collect(Collectors.toUnmodifiableList());
    }

    public SequencedMap<String, OffsetProvider> getAllOffsetProviderConfigs() {
        return this.offsetProviders;
    }

    public boolean validateBaseAndFullConfig() {
        Logger logger = CoordinateOffsetCore.get().getLogger();
        try {
            this.getDefaultOffsetProviderConfig();
        }
        catch (NullPointerException e) {
            logger.severe("Failed to load offset providers from config.");
            logger.severe("An offset provider named \"" + this.defaultOffsetProvider + "\" was configured as the default provider, but no such provider exists.");
            logger.severe("Check your configuration and make sure that:");
            logger.severe("  1) The provider name is spelled correctly.");
            logger.severe("  2) A provider whose name matches exactly is defined in the 'offsetProviders' section.");
            logger.severe("  3) There are no other errors in the log that may indicate why the provider failed to load.");
            logger.severe("If the problem persists, please contact the plugin author for assistance.");
            return false;
        }
        for (OffsetProviderOverrideConfigImpl override : this.offsetProviderOverrides) {
            override.validate(this.offsetProviders, true);
        }
        return true;
    }
}

