/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.config;

import com.jtprince.coordinateoffset.config.CoordinateOffsetConfig;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.Comment;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.Configuration;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Configuration
public class CoordinateOffsetConfigBase
implements CoordinateOffsetConfig {
    @Comment(value={"Do not change this."})
    @Nullable Integer configVersion = null;
    @Comment(value={"", "############################################################################ #", "################### General CoordinateOffset Configuration ################# #", "############################################################################ #", "", "Disable server-side collision checks for the listed blocks.", "  If collision checks are left enabled, movement near these blocks will be", "  extremely glitchy for all players with an offset applied.", "  More info: https://github.com/joshuaprince/CoordinateOffset/issues/8", "Note: Requires a server restart for changes to take effect."})
    FixCollision fixCollision = new FixCollision();
    @Comment(value={"", "If true, players with the `coordinateoffset.bypass` permission will always", "  see their real coordinates (no offsets). Disable this to test the plugin."})
    boolean bypassByPermission = false;
    @Comment(value={"", "Don't send world border packets to players who are far from the world border.", "  Disable if your world border moves, but beware that it may leak coordinates:", "  https://github.com/joshuaprince/CoordinateOffset/wiki/Implications-and-Limitations#world-border"})
    boolean obfuscateWorldBorder = true;
    @Comment(value={"", "Don't send any \"debug\" packets to players with an applied offset.", "  Debug information reveals real coordinates if this is disabled.", "  More info: https://minecraft.wiki/w/Debug_property"})
    boolean obfuscateDebugPropertySubscriptions = true;
    @Comment(value={"", "Enable a log message when a player's offset changes."})
    boolean verbose = false;
    @Nullable Boolean unsafeResetOnDistantTeleport = null;

    @Override
    public boolean getFixCollisionBamboo() {
        return this.fixCollision.bamboo;
    }

    @Override
    public boolean getFixCollisionDripstone() {
        return this.fixCollision.dripstone;
    }

    @Override
    public boolean getBypassByPermission() {
        return this.bypassByPermission;
    }

    @Override
    public boolean getObfuscateWorldBorder() {
        return this.obfuscateWorldBorder;
    }

    @Override
    public boolean getObfuscateDebugPropertySubscriptions() {
        return this.obfuscateDebugPropertySubscriptions;
    }

    @Override
    public boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public boolean getUnsafeResetOnDistantTeleport() {
        return this.unsafeResetOnDistantTeleport != null && this.unsafeResetOnDistantTeleport != false;
    }

    @Configuration
    public static class FixCollision {
        boolean bamboo = true;
        boolean dripstone = true;
    }
}

