/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.config;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.config.ConfigVersion;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfigBase;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfigFull;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.ConfigLib;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.YamlConfigurationProperties;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.YamlConfigurations;
import java.nio.file.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ConfigHolder {
    static YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().header("CoordinateOffset Configuration File\nhttps://github.com/joshuaprince/CoordinateOffset/wiki/Configuration-Guide\nComments left in this file will be deleted when configuration is loaded.\n")).build();
    private final CoordinateOffsetCore core;
    private @Nullable CoordinateOffsetConfigBase runningConfig;
    private boolean safeToWriteToConfigFile = false;

    public ConfigHolder(CoordinateOffsetCore core) {
        this.core = core;
    }

    public CoordinateOffsetConfigBase getConfig() {
        if (this.runningConfig == null) {
            throw new IllegalStateException("CoordinateOffset config is not yet loaded.");
        }
        return this.runningConfig;
    }

    public CoordinateOffsetConfigFull getProviderConfig() {
        CoordinateOffsetConfigBase coordinateOffsetConfigBase = this.runningConfig;
        if (!(coordinateOffsetConfigBase instanceof CoordinateOffsetConfigFull)) {
            throw new IllegalStateException("CoordinateOffset Offset Provider config is not yet loaded.");
        }
        CoordinateOffsetConfigFull fullConfig = (CoordinateOffsetConfigFull)coordinateOffsetConfigBase;
        return fullConfig;
    }

    public void loadBaseConfig() {
        Path configPath = this.core.getAdapter().getConfigPath();
        if (configPath.toFile().exists()) {
            this.runningConfig = YamlConfigurations.load(configPath, CoordinateOffsetConfigBase.class, properties);
            if (ConfigVersion.onLoadBaseConfig(configPath, this.runningConfig)) {
                this.safeToWriteToConfigFile = true;
            }
        } else {
            this.runningConfig = new CoordinateOffsetConfigBase();
            this.safeToWriteToConfigFile = true;
            this.loadFullConfig();
        }
    }

    public boolean loadFullConfig() {
        Path configPath = this.core.getAdapter().getConfigPath();
        if (configPath.toFile().exists()) {
            try {
                CoordinateOffsetConfigFull c = YamlConfigurations.load(configPath, CoordinateOffsetConfigFull.class, properties);
                if (!c.validateBaseAndFullConfig()) {
                    return false;
                }
                this.runningConfig = c;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        } else {
            this.runningConfig = new CoordinateOffsetConfigFull();
        }
        if (this.safeToWriteToConfigFile) {
            this.runningConfig.configVersion = 5;
            YamlConfigurations.save(configPath, CoordinateOffsetConfigFull.class, (CoordinateOffsetConfigFull)this.runningConfig, properties);
        }
        return true;
    }

    public boolean reload() {
        boolean success = false;
        try {
            success = this.loadFullConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (success) {
            CoordinateOffsetCore.get().getLogger().info("Config reloaded.");
        } else {
            CoordinateOffsetCore.get().getLogger().warning("Failed to reload config. Running configuration has not been changed.");
        }
        return success;
    }
}

