/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class OffsetHolder {
    private final CoordinateOffsetCore core;
    private final ConcurrentHashMap<UUID, PlayerOffsetData> playerOffsetData = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Object> pendingDataLocks = new ConcurrentHashMap();

    OffsetHolder(CoordinateOffsetCore core) {
        this.core = core;
    }

    public Offset getOffset(OffsetPlayer player) {
        PlayerOffsetData data = this.playerOffsetData.get(player.getUuid());
        if (data == null) {
            throw new NoSuchElementException("Player " + player.getName() + " has no offset data!");
        }
        return data.currentOffset;
    }

    public Offset getNextOffset(OffsetPlayer player) {
        PlayerOffsetData data = this.playerOffsetData.get(player.getUuid());
        if (data == null) {
            throw new NoSuchElementException("Player " + player.getName() + " has no offset data!");
        }
        return data.nextOffset == null ? data.currentOffset : data.nextOffset;
    }

    public @Nullable Offset getSavedWorldOffset(OffsetPlayer player, String worldName) {
        PlayerOffsetData data = this.playerOffsetData.get(player.getUuid());
        if (data == null) {
            return null;
        }
        return data.savedWorldOffsets.get(worldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Offset waitForJoiningOffset(UUID playerUuid, int timeoutMillis) throws TimeoutException {
        PlayerOffsetData data = this.playerOffsetData.get(playerUuid);
        if (data == null && timeoutMillis > 0) {
            Object pendingOffsetDataLock = this.pendingDataLocks.computeIfAbsent(playerUuid, uuid -> new Object());
            long now = System.currentTimeMillis();
            long deadline = now + (long)timeoutMillis;
            Object object = pendingOffsetDataLock;
            synchronized (object) {
                while (data == null && (now = System.currentTimeMillis()) < deadline) {
                    try {
                        pendingOffsetDataLock.wait(deadline - now);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    data = this.playerOffsetData.get(playerUuid);
                }
            }
        }
        if (data == null) {
            throw new TimeoutException("Player " + String.valueOf(playerUuid) + " has no offset data!");
        }
        return data.currentOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateNextOffset(OffsetProviderContext context) {
        Object pendingOffsetDataLock;
        Offset newOffset = this.core.getOffsetCreator().createOffset(context);
        this.playerOffsetData.compute(context.player().getUuid(), (uuid, existingOffsetData) -> {
            if (existingOffsetData == null) {
                this.debugLog("Generate first: " + String.valueOf(newOffset) + ", " + String.valueOf(newOffset) + ", null");
                return new PlayerOffsetData(Map.of(context.worldName(), newOffset), newOffset, newOffset, null);
            }
            HashMap<String, Offset> offsetPerWorld = new HashMap<String, Offset>(existingOffsetData.savedWorldOffsets());
            offsetPerWorld.put(context.worldName(), newOffset);
            this.debugLog("Generate next: " + String.valueOf(existingOffsetData.previousOffset) + ", " + String.valueOf(existingOffsetData.currentOffset) + ", " + String.valueOf(newOffset));
            return new PlayerOffsetData(Map.copyOf(offsetPerWorld), existingOffsetData.previousOffset, existingOffsetData.currentOffset, newOffset);
        });
        Object object = pendingOffsetDataLock = this.pendingDataLocks.computeIfAbsent(context.player().getUuid(), uuid -> new Object());
        synchronized (object) {
            pendingOffsetDataLock.notifyAll();
        }
    }

    public void swapInNextOffset(OffsetPlayer player) {
        this.playerOffsetData.computeIfPresent(player.getUuid(), (uuid, existingOffsetData) -> {
            if (existingOffsetData.nextOffset == null) {
                return existingOffsetData;
            }
            this.debugLog("Swap in next: " + String.valueOf(existingOffsetData.currentOffset) + ", " + String.valueOf(existingOffsetData.nextOffset) + ", null");
            return new PlayerOffsetData(existingOffsetData.savedWorldOffsets, existingOffsetData.currentOffset, existingOffsetData.nextOffset, null);
        });
    }

    public void remove(UUID uuid) {
        this.playerOffsetData.remove(uuid);
        this.pendingDataLocks.remove(uuid);
    }

    private void debugLog(String message) {
        if (this.core.isDebugEnabled()) {
            this.core.getLogger().info("[Debug] " + message);
        }
    }

    private record PlayerOffsetData(Map<String, Offset> savedWorldOffsets, Offset previousOffset, Offset currentOffset, @Nullable Offset nextOffset) {
    }
}

