/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.CoordinateOffsetPermission;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.config.OffsetProviderOverrideConfig;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderContext;
import java.util.Optional;
import org.jspecify.annotations.NullMarked;

@NullMarked
class OffsetCreator {
    private final CoordinateOffsetCore core;

    OffsetCreator(CoordinateOffsetCore core) {
        this.core = core;
    }

    Offset createOffset(OffsetProviderContext context) {
        Optional<OffsetProviderOverrideConfig> appliedOverride;
        OffsetProvider provider = null;
        ProviderSource providerSource = null;
        Offset savedOffsetInWorld = this.core.getOffsetHolder().getSavedWorldOffset(context.player(), context.worldName());
        if (this.core.getConfig().getBypassByPermission() && context.player().hasPermission(CoordinateOffsetPermission.BYPASS.node)) {
            if (this.core.getConfig().getVerbose()) {
                this.core.getLogger().info("Bypassing offset with permission for player " + context.player().getName() + ".");
            }
            return Offset.ZERO;
        }
        if (provider == null && (appliedOverride = this.core.getProviderConfig().getOffsetProviderOverrides().stream().filter(o -> this.providerOverrideAppliesTo(context, (OffsetProviderOverrideConfig)o)).findFirst()).isPresent()) {
            provider = appliedOverride.get().getOffsetProvider();
            providerSource = ProviderSource.OVERRIDE;
        }
        if (provider == null) {
            provider = this.core.getProviderConfig().getDefaultOffsetProviderConfig();
            providerSource = ProviderSource.DEFAULT;
        }
        Offset offset = provider.provideOffset(context);
        if (this.core.getConfig().getVerbose()) {
            String usingOrReusing = offset.equals(savedOffsetInWorld) ? "Reusing" : "Using";
            String reasonStr = null;
            switch (context.reason()) {
                case JOIN: {
                    reasonStr = "player joined";
                    break;
                }
                case DEATH_RESPAWN: {
                    reasonStr = "player respawned";
                    break;
                }
                case WORLD_CHANGE: {
                    reasonStr = "player changed worlds";
                    break;
                }
                case DISTANT_TELEPORT: {
                    reasonStr = "player teleported";
                }
            }
            String sourceStr = null;
            switch (providerSource.ordinal()) {
                case 0: {
                    sourceStr = "default provider";
                    break;
                }
                case 1: {
                    sourceStr = "config.yml override";
                }
            }
            this.core.getLogger().info(usingOrReusing + " " + String.valueOf(offset) + " from provider \"" + provider.name + "\" (" + sourceStr + ") for player " + context.player().getName() + " in world \"" + context.worldName() + "\" (" + reasonStr + ").");
        }
        return offset;
    }

    private boolean providerOverrideAppliesTo(OffsetProviderContext context, OffsetProviderOverrideConfig override) {
        if (override.getPlayerUuid() != null && !override.getPlayerUuid().equals(context.player().getUuid())) {
            return false;
        }
        if (override.getWorld() != null && !override.getWorld().equals(context.worldName())) {
            return false;
        }
        return override.getPermission() == null || context.player().hasPermission(override.getPermission());
    }

    static enum ProviderSource {
        DEFAULT,
        OVERRIDE;

    }
}

