/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.adapter.OffsetLocation;
import com.jtprince.coordinateoffset.api.CoordinateOffset;
import java.util.Random;
import org.checkerframework.dataflow.qual.Pure;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record Offset(int x, int z) {
    public static final Offset ZERO = new Offset(0, 0);
    public static final int ALIGN_OVERWORLD = 3;

    public Offset {
        if (x % 16 != 0) {
            throw new IllegalArgumentException("Offset x=" + x + " is not chunk-aligned! (must be a multiple of 16)");
        }
        if (z % 16 != 0) {
            throw new IllegalArgumentException("Offset z=" + z + " is not chunk-aligned! (must be a multiple of 16)");
        }
    }

    public static Offset random(int bound) {
        Random random = new Random();
        return Offset.align(random.nextInt(-bound, bound), random.nextInt(-bound, bound), 3);
    }

    public static Offset align(int x, int z, int toChunksPower) {
        int shift = toChunksPower + 4;
        return new Offset((x += 1 << shift - 1) >> shift << shift, (z += 1 << shift - 1) >> shift << shift);
    }

    public static Offset align(int x, int z) {
        return Offset.align(x, z, 0);
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    @Pure
    public Offset scale(int rightShiftAmount) {
        if (rightShiftAmount <= 0) {
            return new Offset(this.x << -rightShiftAmount, this.z << -rightShiftAmount);
        }
        return Offset.align(this.x >> rightShiftAmount, this.z >> rightShiftAmount);
    }

    @Pure
    public Offset scaleByDouble(double scaleFactor) {
        return Offset.align((int)Math.round((double)this.x * scaleFactor), (int)Math.round((double)this.z * scaleFactor));
    }

    @Pure
    public Offset negate() {
        return new Offset(-this.x, -this.z);
    }

    @Pure
    public <T> T apply(T location) throws ClassCastException {
        OffsetLocation l = location instanceof OffsetLocation ? (OffsetLocation)location : CoordinateOffset.api().adaptLocation(location);
        OffsetLocation applied = l.apply(this);
        if (location instanceof OffsetLocation) {
            return (T)applied;
        }
        return (T)applied.getPlatformLocationObject();
    }

    @Pure
    public <T> T unapply(T location) throws ClassCastException {
        OffsetLocation l = location instanceof OffsetLocation ? (OffsetLocation)location : CoordinateOffset.api().adaptLocation(location);
        OffsetLocation unapplied = l.unapply(this);
        if (location instanceof OffsetLocation) {
            return (T)unapplied;
        }
        return (T)unapplied.getPlatformLocationObject();
    }
}

