/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.OffsetCreator;
import com.jtprince.coordinateoffset.OffsetHolder;
import com.jtprince.coordinateoffset.OffsetProviderClassRegistry;
import com.jtprince.coordinateoffset.adapter.CoordinateOffsetAdapter;
import com.jtprince.coordinateoffset.api.CoordinateOffsetAPIImpl;
import com.jtprince.coordinateoffset.config.ConfigHolder;
import com.jtprince.coordinateoffset.config.CoordinateOffsetConfig;
import com.jtprince.coordinateoffset.config.CoordinateOffsetProviderConfig;
import com.jtprince.coordinateoffset.provider.ConstantOffsetProvider;
import com.jtprince.coordinateoffset.provider.RandomOffsetProvider;
import com.jtprince.coordinateoffset.provider.ZeroAtLocationOffsetProvider;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CoordinateOffsetCore {
    private static @Nullable CoordinateOffsetCore singleton = null;
    private final CoordinateOffsetAdapter adapter;
    private final ConfigHolder configHolder;
    private final OffsetProviderClassRegistry registry;
    private final OffsetCreator offsetCreator;
    private final OffsetHolder offsetHolder;
    private final boolean isDebugEnabled = System.getProperty("coordinateoffset.debug", "false").equalsIgnoreCase("true");
    private boolean completedLoading = false;

    private CoordinateOffsetCore(CoordinateOffsetAdapter adapter) {
        this.adapter = adapter;
        this.configHolder = new ConfigHolder(this);
        this.registry = new OffsetProviderClassRegistry();
        this.offsetCreator = new OffsetCreator(this);
        this.offsetHolder = new OffsetHolder(this);
    }

    public static CoordinateOffsetCore bootstrap(CoordinateOffsetAdapter adapter) {
        CoordinateOffsetCore core;
        if (singleton != null) {
            throw new IllegalStateException("CoordinateOffset core is already initialized.");
        }
        singleton = core = new CoordinateOffsetCore(adapter);
        core.configHolder.loadBaseConfig();
        CoordinateOffsetAPIImpl api = new CoordinateOffsetAPIImpl(core);
        CoordinateOffsetAPIImpl.set(api);
        core.getProviderRegistry().registerProviderClass("ConstantOffsetProvider", true, ConstantOffsetProvider::deserialize);
        core.getProviderRegistry().registerProviderClass("RandomOffsetProvider", true, RandomOffsetProvider::deserialize);
        core.getProviderRegistry().registerProviderClass("ZeroAtLocationOffsetProvider", true, ZeroAtLocationOffsetProvider::deserialize);
        return core;
    }

    public static CoordinateOffsetCore bootstrapForTests(CoordinateOffsetAdapter adapter) {
        CoordinateOffsetCore core = new CoordinateOffsetCore(adapter);
        CoordinateOffsetAPIImpl.set(new CoordinateOffsetAPIImpl(core));
        return core;
    }

    public boolean areAllProvidersLoaded() {
        return this.completedLoading;
    }

    public void signalCompletedLoading() {
        if (this.completedLoading) {
            return;
        }
        this.completedLoading = true;
        if (!this.configHolder.loadFullConfig()) {
            this.adapter.shutdown();
        }
    }

    public CoordinateOffsetAdapter getAdapter() {
        return this.adapter;
    }

    public OffsetProviderClassRegistry getProviderRegistry() {
        return this.registry;
    }

    public CoordinateOffsetConfig getConfig() {
        return this.configHolder.getConfig();
    }

    public CoordinateOffsetProviderConfig getProviderConfig() {
        return this.configHolder.getProviderConfig();
    }

    public boolean reloadConfig() {
        return this.configHolder.reload();
    }

    public Logger getLogger() {
        return this.adapter.getLogger();
    }

    OffsetCreator getOffsetCreator() {
        return this.offsetCreator;
    }

    public OffsetHolder getOffsetHolder() {
        return this.offsetHolder;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public static CoordinateOffsetCore get() {
        if (singleton == null) {
            throw new IllegalStateException("CoordinateOffset core is not yet initialized.");
        }
        return singleton;
    }
}

