/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.command;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import squaremap.libraries.org.incendo.cloud.CommandManager;
import squaremap.libraries.org.incendo.cloud.SenderMapper;
import squaremap.libraries.org.incendo.cloud.bukkit.data.SinglePlayerSelector;
import squaremap.libraries.org.incendo.cloud.bukkit.parser.location.Location2DParser;
import squaremap.libraries.org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.execution.ExecutionCoordinator;
import squaremap.libraries.org.incendo.cloud.paper.PaperCommandManager;
import squaremap.libraries.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.squaremap.common.command.BrigadierSetup;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.PlatformCommands;
import xyz.jpenilla.squaremap.common.command.PlayerCommander;
import xyz.jpenilla.squaremap.paper.command.PaperCommander;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitHelper;
import xyz.jpenilla.squaremap.paper.util.Folia;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class PaperCommands
implements PlatformCommands {
    private final JavaPlugin plugin;

    @Inject
    private PaperCommands(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CommandManager<Commander> createCommandManager() {
        SenderMapper<CommandSourceStack, Commander> senderMapper = SenderMapper.create(PaperCommander::from, commander -> ((PaperCommander)commander).stack());
        PaperCommandManager<Commander> mgr = PaperCommandManager.builder(senderMapper).executionCoordinator(ExecutionCoordinator.builder().synchronizeExecution(Folia.FOLIA).build()).buildOnEnable((Plugin)this.plugin);
        BrigadierSetup.setup(mgr);
        return mgr;
    }

    @Override
    public ParserDescriptor<Commander, BlockPos> columnPosParser() {
        return Location2DParser.location2DParser().mapSuccess(BlockPos.class, (ctx, loc) -> CompletableFuture.completedFuture(new BlockPos(loc.getBlockX(), 0, loc.getBlockZ())));
    }

    @Override
    public ParserDescriptor<Commander, ?> singlePlayerSelectorParser() {
        return SinglePlayerSelectorParser.singlePlayerSelectorParser();
    }

    @Override
    public Optional<ServerPlayer> extractPlayer(String argName, CommandContext<Commander> context) {
        Commander sender = context.sender();
        @Nullable SinglePlayerSelector selector = context.getOrDefault(argName, null);
        if (selector == null) {
            if (sender instanceof PlayerCommander) {
                PlayerCommander player = (PlayerCommander)sender;
                return Optional.of(player.player());
            }
            return Optional.empty();
        }
        return Optional.of(CraftBukkitHelper.serverPlayer((Player)selector.single()));
    }
}

