/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.WorldManagerImpl;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitHelper;
import xyz.jpenilla.squaremap.paper.util.WorldNameToKeyMigration;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class PaperWorldManager
extends WorldManagerImpl {
    private final DirectoryProvider directoryProvider;

    @Inject
    private PaperWorldManager(MapWorldInternal.Factory factory, ServerAccess serverAccess, DirectoryProvider directoryProvider, ConfigManager configManager) {
        super(factory, serverAccess, configManager);
        this.directoryProvider = directoryProvider;
    }

    @Override
    public void initWorld(ServerLevel level) {
        WorldNameToKeyMigration.tryMoveDirectories(this.directoryProvider, level);
        super.initWorld(level);
    }

    public Optional<MapWorldInternal> getWorldIfEnabled(World world) {
        return this.getWorldIfEnabled(CraftBukkitHelper.serverLevel(world));
    }
}

