/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityLimit;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;

public final class VisibilityLimitImpl
implements VisibilityLimit {
    private static final int REGION_SIZE_CHUNKS = Numbers.regionToChunk(1);
    private final List<VisibilityShape> shapes = new CopyOnWriteArrayList<VisibilityShape>();
    private final MapWorld world;

    public VisibilityLimitImpl(MapWorld world) {
        this.world = world;
    }

    public int countChunksInRegion(@NonNull RegionCoordinate region) {
        return switch (this.shapes.size()) {
            case 0 -> REGION_SIZE_CHUNKS * REGION_SIZE_CHUNKS;
            case 1 -> this.shapes.get(0).countChunksInRegion(this.world, region.x(), region.z());
            default -> {
                int chunkXStart = region.getChunkX();
                int chunkZStart = region.getChunkZ();
                int count = 0;
                for (int i = 0; i < REGION_SIZE_CHUNKS; ++i) {
                    for (int j = 0; j < REGION_SIZE_CHUNKS; ++j) {
                        if (!this.shouldRenderChunk(chunkXStart + i, chunkZStart + j)) continue;
                        ++count;
                    }
                }
                yield count;
            }
        };
    }

    @Override
    public @NonNull List<VisibilityShape> getShapes() {
        return this.shapes;
    }

    @Override
    public boolean isWithinLimit(int blockX, int blockZ) {
        return this.shouldRenderColumn(blockX, blockZ);
    }

    public void load(List<VisibilityShape> configLimits) {
        this.shapes.clear();
        for (VisibilityShape shape : configLimits) {
            if (shape == VisibilityShape.NULL) continue;
            this.shapes.add(shape);
        }
    }

    public boolean shouldRenderChunk(ChunkCoordinate chunkCoord) {
        return this.shouldRenderChunk(chunkCoord.x(), chunkCoord.z());
    }

    public boolean shouldRenderChunk(int chunkX, int chunkZ) {
        if (this.shapes.size() == 0) {
            return true;
        }
        for (VisibilityShape shape : this.shapes) {
            if (!shape.shouldRenderChunk(this.world, chunkX, chunkZ)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRenderColumn(int blockX, int blockZ) {
        if (this.shapes.size() == 0) {
            return true;
        }
        for (VisibilityShape shape : this.shapes) {
            if (!shape.shouldRenderColumn(this.world, blockX, blockZ)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldRenderRegion(int regionX, int regionZ) {
        if (this.shapes.size() == 0) {
            return true;
        }
        for (VisibilityShape shape : this.shapes) {
            if (!shape.shouldRenderRegion(this.world, regionX, regionZ)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRenderRegion(RegionCoordinate region) {
        return this.shouldRenderRegion(region.x(), region.z());
    }
}

