/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.util.CheckedConsumer;
import xyz.jpenilla.squaremap.common.util.NamedThreadFactory;

@DefaultQualifier(value=NonNull.class)
public final class Util {
    private static final Gson GSON = new GsonBuilder().create();

    private Util() {
    }

    public static Gson gson() {
        return GSON;
    }

    public static <X extends Throwable> RuntimeException rethrow(Throwable t) throws X {
        throw t;
    }

    public static <T, X extends Throwable> Consumer<T> sneaky(CheckedConsumer<T, X> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable thr) {
                Util.rethrow(thr);
            }
        };
    }

    public static ThreadFactory squaremapThreadFactory(String name) {
        return new NamedThreadFactory("squaremap-" + name);
    }

    public static ThreadFactory squaremapThreadFactory(String name, ServerLevel level) {
        return Util.squaremapThreadFactory(name + "-[" + String.valueOf(level.dimension().location()) + "]");
    }

    public static ThreadPoolExecutor newFixedThreadPool(int size, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, rejectedExecutionHandler);
    }

    public static void shutdownExecutor(ExecutorService service, TimeUnit timeoutUnit, long timeoutLength) {
        boolean didShutdown;
        service.shutdown();
        try {
            didShutdown = service.awaitTermination(timeoutLength, timeoutUnit);
        }
        catch (InterruptedException ignore) {
            didShutdown = false;
        }
        if (!didShutdown) {
            service.shutdownNow();
        }
    }

    public static <T> T requireEntry(Registry<T> registry, ResourceLocation location) {
        if (!registry.containsKey(location)) {
            throw new IllegalArgumentException("No such entry '" + String.valueOf(location) + "' in registry '" + String.valueOf(registry.key()) + "'");
        }
        return (T)Objects.requireNonNull(registry.getValue(location));
    }

    public static String levelConfigName(ServerLevel level) {
        return level.dimension().location().toString();
    }

    public static String levelWebName(ServerLevel level) {
        return level.dimension().location().toString().replace(":", "_");
    }

    public static WorldIdentifier worldIdentifier(ServerLevel level) {
        ResourceLocation location = level.dimension().location();
        return Util.worldIdentifier(location);
    }

    public static WorldIdentifier worldIdentifier(ResourceLocation location) {
        return WorldIdentifier.create(location.getNamespace(), location.getPath());
    }

    public static byte[] raw(FriendlyByteBuf buf) {
        byte[] data = new byte[buf.readableBytes()];
        buf.readBytes(data);
        return data;
    }

    public static Registry<Biome> biomeRegistry(CommonLevelAccessor level) {
        return Util.biomeRegistry(level.registryAccess());
    }

    public static Registry<Biome> biomeRegistry(RegistryAccess registryAccess) {
        return registryAccess.lookupOrThrow(Registries.BIOME);
    }

    public static @Nullable Manifest manifest(Class<?> clazz) {
        Manifest manifest;
        block9: {
            String classLocation = "/" + clazz.getName().replace(".", "/") + ".class";
            @Nullable URL resource = clazz.getResource(classLocation);
            if (resource == null) {
                return null;
            }
            String classFilePath = resource.toString().replace("\\", "/");
            String archivePath = classFilePath.substring(0, classFilePath.length() - classLocation.length());
            InputStream stream = URI.create(archivePath + "/META-INF/MANIFEST.MF").toURL().openStream();
            try {
                manifest = new Manifest(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            stream.close();
        }
        return manifest;
    }
}

