/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Colors;

@DefaultQualifier(value=NonNull.class)
public final class BlockColors {
    private final Reference2IntMap<Block> staticColorMap;
    private final Reference2ObjectMap<Block, DynamicColorGetter> dynamicColorMap;

    private BlockColors(MapWorldInternal world) {
        Reference2IntOpenHashMap staticColors = new Reference2IntOpenHashMap(world.advanced().COLOR_OVERRIDES_BLOCKS);
        staticColors.defaultReturnValue(-1);
        this.staticColorMap = Reference2IntMaps.unmodifiable((Reference2IntMap)staticColors);
        this.dynamicColorMap = this.loadDynamicColors();
    }

    private Reference2ObjectMap<Block, DynamicColorGetter> loadDynamicColors() {
        HashMap<Block, DynamicColorGetter> map = new HashMap<Block, DynamicColorGetter>();
        map.put(Blocks.MELON_STEM, BlockColors::melonAndPumpkinStem);
        map.put(Blocks.PUMPKIN_STEM, BlockColors::melonAndPumpkinStem);
        map.put(Blocks.WHEAT, BlockColors::wheat);
        return Reference2ObjectMaps.unmodifiable((Reference2ObjectMap)new Reference2ObjectOpenHashMap(map));
    }

    public int color(BlockState state) {
        Block block = state.getBlock();
        int staticColor = this.staticColorMap.getInt((Object)block);
        if (staticColor != -1) {
            return staticColor;
        }
        @Nullable DynamicColorGetter func = (DynamicColorGetter)this.dynamicColorMap.get((Object)block);
        if (func != null) {
            return func.color(state);
        }
        return -1;
    }

    private static int melonAndPumpkinStem(BlockState state) {
        int age = (Integer)state.getValue((Property)StemBlock.AGE);
        int k = age * 32;
        int l = 255 - age * 8;
        int m = age * 4;
        return k << 16 | l << 8 | m;
    }

    private static int wheat(BlockState state) {
        float factor = (float)((Integer)state.getValue((Property)CropBlock.AGE) + 1) / 8.0f;
        return Colors.mix(Colors.plantMapColor(), 14465893, factor);
    }

    public static BlockColors create(MapWorldInternal mapWorld) {
        return new BlockColors(mapWorld);
    }

    @FunctionalInterface
    private static interface DynamicColorGetter {
        public int color(BlockState var1);
    }
}

