/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.io.leangen.geantyref.TypeFactory;
import squaremap.libraries.io.leangen.geantyref.TypeToken;
import squaremap.libraries.org.spongepowered.configurate.ConfigurateException;
import squaremap.libraries.org.spongepowered.configurate.ConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.serialize.SerializationException;
import squaremap.libraries.org.spongepowered.configurate.transformation.TransformAction;
import xyz.jpenilla.squaremap.common.util.CheckedConsumer;

@DefaultQualifier(value=NonNull.class)
final class Transformations {
    private Transformations() {
    }

    static Set<String> maybeMinecraft(String name) {
        return Set.of(name, "minecraft:" + name);
    }

    static TransformAction eachMapChild(CheckedConsumer<ConfigurationNode, ConfigurateException> action) {
        return (path, node) -> {
            Set<Object> childKeys = node.childrenMap().keySet();
            for (Object childKey : childKeys) {
                ConfigurationNode childNode = node.node(childKey);
                action.accept(childNode);
            }
            return null;
        };
    }

    static TransformAction modifyStringMap(Consumer<Map<String, String>> consumer) {
        return Transformations.modifyMap(String.class, String.class, consumer);
    }

    static <K, V> TransformAction modifyMap(Class<K> keyType, Class<V> valueType, Consumer<Map<K, V>> consumer) {
        return (path, node) -> {
            Type type = TypeFactory.parameterizedClass(Map.class, keyType, valueType);
            Map map = (Map)node.get(type, new HashMap());
            consumer.accept(map);
            node.set(type, (Object)map);
            return null;
        };
    }

    static void applyMapKeyOrListValueRenames(List<ConfigurationNode> sections, Map<Set<String>, String> renames) throws SerializationException {
        for (ConfigurationNode sectionNode : sections) {
            if (sectionNode.isList()) {
                List<String> list = Objects.requireNonNull(sectionNode.getList(String.class));
                boolean anyRemoved = false;
                for (Map.Entry<Set<String>, String> renameEntry : renames.entrySet()) {
                    boolean removed = false;
                    for (String from : renameEntry.getKey()) {
                        removed |= list.remove(from);
                    }
                    if (removed) {
                        list.add(renameEntry.getValue());
                    }
                    anyRemoved |= removed;
                }
                if (!anyRemoved) continue;
                sectionNode.setList(String.class, list);
                continue;
            }
            if (!sectionNode.isMap()) continue;
            TypeToken<Map<String, String>> type = new TypeToken<Map<String, String>>(){};
            Map<String, String> map = Objects.requireNonNull(sectionNode.get(type));
            boolean anyRemoved = false;
            for (Map.Entry<Set<String>, String> renameEntry : renames.entrySet()) {
                String removed = null;
                for (String from : renameEntry.getKey()) {
                    @Nullable String remove = map.remove(from);
                    if (remove == null) continue;
                    removed = remove;
                }
                if (removed == null) continue;
                map.put(renameEntry.getValue(), removed);
                anyRemoved = true;
            }
            if (!anyRemoved) continue;
            sectionNode.set(type, map);
        }
    }
}

