/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.util.ArrayList;
import java.util.List;
import squaremap.libraries.org.spongepowered.configurate.NodePath;
import squaremap.libraries.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import xyz.jpenilla.squaremap.common.config.AbstractConfig;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;

public final class Config
extends AbstractConfig {
    private static final int LATEST_VERSION = 2;
    static Config config;
    public static String LANGUAGE_FILE;
    public static boolean DEBUG_MODE;
    public static boolean UPDATE_CHECKER;
    public static String WEB_ADDRESS;
    public static String WEB_DIR;
    public static boolean UPDATE_WEB_DIR;
    public static boolean COMPRESS_IMAGES;
    private static double COMPRESSION_RATIO_CONFIG;
    public static float COMPRESSION_RATIO;
    public static boolean HTTPD_ENABLED;
    public static String HTTPD_BIND;
    public static int HTTPD_PORT;
    public static boolean FLUSH_JSON_IMMEDIATELY;
    public static boolean UI_COORDINATES_ENABLED;
    public static boolean UI_LINK_ENABLED;
    public static String UI_SIDEBAR_PINNED;
    public static String MAIN_COMMAND_LABEL;
    public static final List<String> MAIN_COMMAND_ALIASES;
    public static volatile boolean PROGRESS_LOGGING;
    public static volatile int PROGRESS_LOGGING_INTERVAL;

    Config(DirectoryProvider directoryProvider) {
        super(directoryProvider.dataDirectory(), Config.class, "config.yml", 2);
    }

    @Override
    protected void addVersions(ConfigurationTransformation.VersionedBuilder versionedBuilder) {
        ConfigurationTransformation oneToTwo = ConfigurationTransformation.builder().addAction(NodePath.path("settings", "image-quality", "compress-images"), (path, node) -> {
            double d = node.getDouble();
            node.raw(null);
            node.node("enabled").set(d != 0.0);
            node.node("value").set(d == 0.0 ? d : 1.0 - d);
            return null;
        }).build();
        versionedBuilder.addVersion(2, oneToTwo);
    }

    public static void reload(DirectoryProvider directoryProvider) {
        config = new Config(directoryProvider);
        config.readConfig(Config.class, null);
    }

    private static void baseSettings() {
        LANGUAGE_FILE = config.getString("settings.language-file", LANGUAGE_FILE);
        DEBUG_MODE = config.getBoolean("settings.debug-mode", DEBUG_MODE);
        UPDATE_CHECKER = config.getBoolean("settings.update-checker", UPDATE_CHECKER);
        WEB_ADDRESS = config.getString("settings.web-address", WEB_ADDRESS);
    }

    private static void webDirSettings() {
        WEB_DIR = config.getString("settings.web-directory.path", WEB_DIR);
        UPDATE_WEB_DIR = config.getBoolean("settings.web-directory.auto-update", UPDATE_WEB_DIR);
    }

    private static void imageQualitySettings() {
        COMPRESS_IMAGES = config.getBoolean("settings.image-quality.compress-images.enabled", COMPRESS_IMAGES);
        COMPRESSION_RATIO_CONFIG = config.getDouble("settings.image-quality.compress-images.value", COMPRESSION_RATIO_CONFIG);
        COMPRESSION_RATIO = (float)(1.0 - COMPRESSION_RATIO_CONFIG);
    }

    private static void internalWebServerSettings() {
        HTTPD_ENABLED = config.getBoolean("settings.internal-webserver.enabled", HTTPD_ENABLED);
        HTTPD_BIND = config.getString("settings.internal-webserver.bind", HTTPD_BIND);
        HTTPD_PORT = config.getInt("settings.internal-webserver.port", HTTPD_PORT);
        FLUSH_JSON_IMMEDIATELY = config.getBoolean("settings.internal-webserver.flush-json-immediately", FLUSH_JSON_IMMEDIATELY);
    }

    private static void uiSettings() {
        UI_COORDINATES_ENABLED = config.getBoolean("settings.ui.coordinates.enabled", UI_COORDINATES_ENABLED);
        UI_LINK_ENABLED = config.getBoolean("settings.ui.link.enabled", UI_LINK_ENABLED);
        UI_SIDEBAR_PINNED = config.getString("settings.ui.sidebar.pinned", UI_SIDEBAR_PINNED);
    }

    private static void commandSettings() {
        MAIN_COMMAND_LABEL = config.getString("settings.commands.main-command-label", MAIN_COMMAND_LABEL);
        MAIN_COMMAND_ALIASES.clear();
        MAIN_COMMAND_ALIASES.addAll(config.getList(String.class, "settings.commands.main-command-aliases", List.of("map")));
    }

    public static void toggleProgressLogging() {
        PROGRESS_LOGGING = !PROGRESS_LOGGING;
        config.set("settings.render-progress-logging.enabled", PROGRESS_LOGGING);
        config.save();
    }

    public static void setLoggingInterval(int rate) {
        PROGRESS_LOGGING_INTERVAL = rate;
        config.set("settings.render-progress-logging.interval-seconds", rate);
        config.save();
    }

    private static void progressLogging() {
        PROGRESS_LOGGING = config.getBoolean("settings.render-progress-logging.enabled", true);
        PROGRESS_LOGGING_INTERVAL = config.getInt("settings.render-progress-logging.interval-seconds", 1);
    }

    public static Config config() {
        return config;
    }

    static {
        LANGUAGE_FILE = "lang-en.yml";
        DEBUG_MODE = false;
        UPDATE_CHECKER = true;
        WEB_ADDRESS = "http://localhost:8080";
        WEB_DIR = "web";
        UPDATE_WEB_DIR = true;
        COMPRESS_IMAGES = false;
        COMPRESSION_RATIO_CONFIG = 0.0;
        HTTPD_ENABLED = true;
        HTTPD_BIND = "0.0.0.0";
        HTTPD_PORT = 8080;
        FLUSH_JSON_IMMEDIATELY = false;
        UI_COORDINATES_ENABLED = true;
        UI_LINK_ENABLED = true;
        UI_SIDEBAR_PINNED = "unpinned";
        MAIN_COMMAND_LABEL = "squaremap";
        MAIN_COMMAND_ALIASES = new ArrayList<String>();
    }
}

