/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.description.Description;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import squaremap.libraries.org.incendo.cloud.parser.standard.IntegerParser;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlatformCommands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.parser.MapWorldParser;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;

@DefaultQualifier(value=NonNull.class)
public final class RadiusRenderCommand
extends SquaremapCommand {
    private final PlatformCommands platformCommands;

    @Inject
    private RadiusRenderCommand(Commands commands, PlatformCommands platformCommands) {
        super(commands);
        this.platformCommands = platformCommands;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("radiusrender", new String[0]).required("world", MapWorldParser.mapWorldParser()).required("radius", IntegerParser.integerParser(1)).optional("center", this.platformCommands.columnPosParser(), (Description)RichDescription.richDescription(Messages.OPTIONAL_CENTER_ARGUMENT_DESCRIPTION)).commandDescription(RichDescription.richDescription(Messages.RADIUSRENDER_COMMAND_DESCRIPTION)).permission("squaremap.command.radiusrender").handler(this::executeRadiusRender));
    }

    private void executeRadiusRender(CommandContext<Commander> context) {
        Commander sender = context.sender();
        MapWorldInternal world = (MapWorldInternal)context.get("world");
        int radius = (Integer)context.get("radius");
        @Nullable BlockPos center = context.optional("center").orElse(null);
        if (center == null) {
            center = new BlockPos(0, 0, 0);
        }
        if (world.renderManager().isRendering()) {
            sender.sendMessage(Messages.RENDER_IN_PROGRESS.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
            return;
        }
        sender.sendMessage(Components.miniMessage(Messages.LOG_STARTED_RADIUSRENDER, new TagResolver[]{Components.worldPlaceholder(world)}));
        world.renderManager().startRender(context.get(Commands.RENDER_FACTORY).createRadiusRender(world, center, radius));
    }
}

