/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.description.Description;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.parser.MapWorldParser;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.CommandUtil;
import xyz.jpenilla.squaremap.common.util.Components;

@DefaultQualifier(value=NonNull.class)
public final class PauseRenderCommand
extends SquaremapCommand {
    @Inject
    private PauseRenderCommand(Commands commands) {
        super(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("pauserender", new String[0]).optional("world", MapWorldParser.mapWorldParser(), (Description)RichDescription.richDescription(Messages.OPTIONAL_WORLD_ARGUMENT_DESCRIPTION)).commandDescription(RichDescription.richDescription(Messages.PAUSE_RENDER_COMMAND_DESCRIPTION)).permission("squaremap.command.pauserender").handler(this::executePauseRender));
    }

    private void executePauseRender(CommandContext<Commander> context) {
        Commander sender = context.sender();
        MapWorldInternal world = CommandUtil.resolveWorld(context);
        world.renderManager().pauseRenders(!world.renderManager().rendersPaused());
        if (world.renderManager().rendersPaused()) {
            sender.sendMessage(Messages.PAUSED_RENDER.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
        } else {
            sender.sendMessage(Messages.UNPAUSED_RENDER.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
        }
    }
}

