/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api.marker;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.marker.IPolygon;
import xyz.jpenilla.squaremap.api.marker.Marker;

public final class Polygon
extends Marker
implements IPolygon {
    private final List<Point> mainPolygon;
    private final List<List<Point>> negativeSpace;

    Polygon(@NonNull List<Point> points, @NonNull List<List<Point>> negativeSpace) {
        this.mainPolygon = new ArrayList<Point>(points);
        this.negativeSpace = new ArrayList<List<Point>>(negativeSpace);
    }

    @Override
    public @NonNull List<List<Point>> negativeSpace() {
        return this.negativeSpace;
    }

    @Override
    public @NonNull List<Point> mainPolygon() {
        return this.mainPolygon;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @Nullable Polygon polygon = (Polygon)o;
        return this.markerOptionsMatch(polygon) && this.mainPolygon.equals(polygon.mainPolygon) && this.negativeSpace.equals(polygon.negativeSpace);
    }

    public int hashCode() {
        return Objects.hash(this.markerOptions(), this.mainPolygon, this.negativeSpace);
    }
}

