/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

final class Trie<T> {
    private final char[] childMap;
    private final Trie<T>[] children;
    private final boolean terminal;
    @Nullable
    private final T value;
    private static final char[] ZERO_CHARS = new char[0];
    private static final Trie<?>[] ZERO_TRIES = new Trie[0];

    public Trie(Map<String, T> elements) {
        this(Trie.sortedUniqEntries(elements), 0);
    }

    private Trie(List<Map.Entry<String, T>> elements, int depth) {
        this(elements, depth, 0, elements.size());
    }

    private Trie(List<Map.Entry<String, T>> elements, int depth, int start, int end) {
        int n;
        int pos = start;
        boolean bl = this.terminal = depth == elements.get(pos).getKey().length();
        if (this.terminal) {
            this.value = elements.get(pos).getValue();
            if (pos + 1 == end) {
                this.childMap = ZERO_CHARS;
                this.children = ZERO_TRIES;
                return;
            }
            ++pos;
        } else {
            this.value = null;
        }
        int childCount = 0;
        int n2 = -1;
        for (int i = pos; i < end; ++i) {
            char c;
            char ch = elements.get(i).getKey().charAt(depth);
            if (ch == c) continue;
            ++childCount;
            c = ch;
        }
        this.childMap = new char[childCount];
        this.children = new Trie[childCount];
        int n3 = pos;
        int childIndex = 0;
        char lastCh = elements.get(pos).getKey().charAt(depth);
        for (int i = pos + 1; i < end; ++i) {
            char ch = elements.get(i).getKey().charAt(depth);
            if (ch == lastCh) continue;
            this.childMap[childIndex] = lastCh;
            this.children[childIndex++] = new Trie<T>(elements, depth + 1, n, i);
            n = i;
            lastCh = ch;
        }
        this.childMap[childIndex] = lastCh;
        this.children[childIndex++] = new Trie<T>(elements, depth + 1, n, end);
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public Trie<T> lookup(char ch) {
        int i = Arrays.binarySearch(this.childMap, ch);
        return i >= 0 ? this.children[i] : null;
    }

    public Trie<T> lookup(CharSequence s) {
        Trie<T> t = this;
        int n = s.length();
        for (int i = 0; i < n && null != (t = t.lookup(s.charAt(i))); ++i) {
        }
        return t;
    }

    public boolean contains(char ch) {
        return Arrays.binarySearch(this.childMap, ch) >= 0;
    }

    private static <U> List<Map.Entry<String, U>> sortedUniqEntries(Map<String, U> m) {
        return new ArrayList<Map.Entry<String, U>>(new TreeMap<String, U>(m).entrySet());
    }

    public void toStringList(List<String> strings) {
        this.toStringList("", strings);
    }

    private void toStringList(String prefix, List<String> strings) {
        if (this.terminal) {
            strings.add(prefix);
        }
        int n = this.childMap.length;
        for (int i = 0; i < n; ++i) {
            super.toStringList(prefix + this.childMap[i], strings);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(0, sb);
        return sb.toString();
    }

    private void toStringBuilder(int depth, StringBuilder sb) {
        sb.append(this.terminal ? "terminal" : "nonterminal");
        int childDepth = depth + 1;
        for (int i = 0; i < this.childMap.length; ++i) {
            sb.append('\n');
            for (int d = 0; d < childDepth; ++d) {
                sb.append('\t');
            }
            sb.append('\'').append(this.childMap[i]).append("' ");
            super.toStringBuilder(childDepth, sb);
        }
    }
}

