/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.processors.confirmation;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.processors.cache.CloudCache;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationConfiguration;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationContext;

@Generated(from="ConfirmationConfiguration", generator="Immutables")
public final class ImmutableConfirmationConfiguration<C>
implements ConfirmationConfiguration<C> {
    private final @NonNull CloudCache<C, ConfirmationContext<C>> cache;
    private final @NonNull Consumer<C> noPendingCommandNotifier;
    private final @NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier;
    private final @NonNull Predicate<CommandContext<C>> bypassConfirmation;
    private final @Nullable Duration expiration;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableConfirmationConfiguration(@NonNull CloudCache<C, ConfirmationContext<C>> cache, @NonNull Consumer<C> noPendingCommandNotifier, @NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier, @NonNull Predicate<CommandContext<C>> bypassConfirmation, @Nullable Duration expiration) {
        this.cache = Objects.requireNonNull(cache, "cache");
        this.noPendingCommandNotifier = Objects.requireNonNull(noPendingCommandNotifier, "noPendingCommandNotifier");
        this.confirmationRequiredNotifier = Objects.requireNonNull(confirmationRequiredNotifier, "confirmationRequiredNotifier");
        this.bypassConfirmation = Objects.requireNonNull(bypassConfirmation, "bypassConfirmation");
        this.expiration = expiration;
        this.initShim = null;
    }

    private ImmutableConfirmationConfiguration(Builder<C> builder) {
        this.cache = builder.cache;
        this.noPendingCommandNotifier = builder.noPendingCommandNotifier;
        this.confirmationRequiredNotifier = builder.confirmationRequiredNotifier;
        if (builder.bypassConfirmationIsSet()) {
            this.initShim.bypassConfirmation(builder.bypassConfirmation);
        }
        if (builder.expirationIsSet()) {
            this.initShim.expiration(builder.expiration);
        }
        this.bypassConfirmation = this.initShim.bypassConfirmation();
        this.expiration = this.initShim.expiration();
        this.initShim = null;
    }

    private ImmutableConfirmationConfiguration(ImmutableConfirmationConfiguration<C> original, @NonNull CloudCache<C, ConfirmationContext<C>> cache, @NonNull Consumer<C> noPendingCommandNotifier, @NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier, @NonNull Predicate<CommandContext<C>> bypassConfirmation, @Nullable Duration expiration) {
        this.cache = cache;
        this.noPendingCommandNotifier = noPendingCommandNotifier;
        this.confirmationRequiredNotifier = confirmationRequiredNotifier;
        this.bypassConfirmation = bypassConfirmation;
        this.expiration = expiration;
        this.initShim = null;
    }

    private @NonNull Predicate<CommandContext<C>> bypassConfirmationInitialize() {
        return ConfirmationConfiguration.super.bypassConfirmation();
    }

    private @Nullable Duration expirationInitialize() {
        return ConfirmationConfiguration.super.expiration();
    }

    @Override
    public @NonNull CloudCache<C, ConfirmationContext<C>> cache() {
        return this.cache;
    }

    @Override
    public @NonNull Consumer<C> noPendingCommandNotifier() {
        return this.noPendingCommandNotifier;
    }

    @Override
    public @NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier() {
        return this.confirmationRequiredNotifier;
    }

    @Override
    public @NonNull Predicate<CommandContext<C>> bypassConfirmation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bypassConfirmation() : this.bypassConfirmation;
    }

    @Override
    public @Nullable Duration expiration() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expiration() : this.expiration;
    }

    public final ImmutableConfirmationConfiguration<C> withCache(@NonNull CloudCache<C, ConfirmationContext<C>> value) {
        if (this.cache == value) {
            return this;
        }
        @NonNull CloudCache<C, ConfirmationContext<C>> newValue = Objects.requireNonNull(value, "cache");
        return new ImmutableConfirmationConfiguration<C>(this, newValue, this.noPendingCommandNotifier, this.confirmationRequiredNotifier, this.bypassConfirmation, this.expiration);
    }

    public final ImmutableConfirmationConfiguration<C> withNoPendingCommandNotifier(@NonNull Consumer<C> value) {
        if (this.noPendingCommandNotifier == value) {
            return this;
        }
        @NonNull Consumer<C> newValue = Objects.requireNonNull(value, "noPendingCommandNotifier");
        return new ImmutableConfirmationConfiguration<C>(this, this.cache, newValue, this.confirmationRequiredNotifier, this.bypassConfirmation, this.expiration);
    }

    public final ImmutableConfirmationConfiguration<C> withConfirmationRequiredNotifier(@NonNull BiConsumer<C, ConfirmationContext<C>> value) {
        if (this.confirmationRequiredNotifier == value) {
            return this;
        }
        @NonNull BiConsumer<C, ConfirmationContext<C>> newValue = Objects.requireNonNull(value, "confirmationRequiredNotifier");
        return new ImmutableConfirmationConfiguration<C>(this, this.cache, this.noPendingCommandNotifier, newValue, this.bypassConfirmation, this.expiration);
    }

    public final ImmutableConfirmationConfiguration<C> withBypassConfirmation(@NonNull Predicate<CommandContext<C>> value) {
        if (this.bypassConfirmation == value) {
            return this;
        }
        @NonNull Predicate<CommandContext<C>> newValue = Objects.requireNonNull(value, "bypassConfirmation");
        return new ImmutableConfirmationConfiguration<C>(this, this.cache, this.noPendingCommandNotifier, this.confirmationRequiredNotifier, newValue, this.expiration);
    }

    public final ImmutableConfirmationConfiguration<C> withExpiration(@Nullable Duration value) {
        if (this.expiration == value) {
            return this;
        }
        return new ImmutableConfirmationConfiguration<C>(this, this.cache, this.noPendingCommandNotifier, this.confirmationRequiredNotifier, this.bypassConfirmation, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfirmationConfiguration && this.equalTo(0, (ImmutableConfirmationConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfirmationConfiguration<?> another) {
        return this.cache.equals(another.cache) && this.noPendingCommandNotifier.equals(another.noPendingCommandNotifier) && this.confirmationRequiredNotifier.equals(another.confirmationRequiredNotifier) && this.bypassConfirmation.equals(another.bypassConfirmation) && Objects.equals(this.expiration, another.expiration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cache.hashCode();
        h += (h << 5) + this.noPendingCommandNotifier.hashCode();
        h += (h << 5) + this.confirmationRequiredNotifier.hashCode();
        h += (h << 5) + this.bypassConfirmation.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiration);
        return h;
    }

    public String toString() {
        return "ConfirmationConfiguration{cache=" + this.cache + ", noPendingCommandNotifier=" + this.noPendingCommandNotifier + ", confirmationRequiredNotifier=" + this.confirmationRequiredNotifier + ", bypassConfirmation=" + this.bypassConfirmation + ", expiration=" + this.expiration + "}";
    }

    public static <C> ImmutableConfirmationConfiguration<C> of(@NonNull CloudCache<C, ConfirmationContext<C>> cache, @NonNull Consumer<C> noPendingCommandNotifier, @NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier, @NonNull Predicate<CommandContext<C>> bypassConfirmation, @Nullable Duration expiration) {
        return new ImmutableConfirmationConfiguration<C>(cache, noPendingCommandNotifier, confirmationRequiredNotifier, bypassConfirmation, expiration);
    }

    public static <C> ImmutableConfirmationConfiguration<C> copyOf(ConfirmationConfiguration<C> instance) {
        if (instance instanceof ImmutableConfirmationConfiguration) {
            return (ImmutableConfirmationConfiguration)instance;
        }
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ImmutableConfirmationConfiguration.builder()).cache((CloudCache)instance.cache())).noPendingCommandNotifier((Consumer)instance.noPendingCommandNotifier())).confirmationRequiredNotifier((BiConsumer)instance.confirmationRequiredNotifier())).bypassConfirmation((Predicate)instance.bypassConfirmation())).expiration(instance.expiration())).build();
    }

    public static <C> CacheBuildStage<C> builder() {
        return new Builder();
    }

    @Generated(from="ConfirmationConfiguration", generator="Immutables")
    private final class InitShim {
        private byte bypassConfirmationBuildStage = 0;
        private @NonNull Predicate<CommandContext<C>> bypassConfirmation;
        private byte expirationBuildStage = 0;
        private @Nullable Duration expiration;

        private InitShim() {
        }

        @NonNull Predicate<CommandContext<C>> bypassConfirmation() {
            if (this.bypassConfirmationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bypassConfirmationBuildStage == 0) {
                this.bypassConfirmationBuildStage = (byte)-1;
                this.bypassConfirmation = Objects.requireNonNull(ImmutableConfirmationConfiguration.this.bypassConfirmationInitialize(), "bypassConfirmation");
                this.bypassConfirmationBuildStage = 1;
            }
            return this.bypassConfirmation;
        }

        void bypassConfirmation(@NonNull Predicate<CommandContext<C>> bypassConfirmation) {
            this.bypassConfirmation = bypassConfirmation;
            this.bypassConfirmationBuildStage = 1;
        }

        @Nullable Duration expiration() {
            if (this.expirationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expirationBuildStage == 0) {
                this.expirationBuildStage = (byte)-1;
                this.expiration = ImmutableConfirmationConfiguration.this.expirationInitialize();
                this.expirationBuildStage = 1;
            }
            return this.expiration;
        }

        void expiration(@Nullable Duration expiration) {
            this.expiration = expiration;
            this.expirationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.bypassConfirmationBuildStage == -1) {
                attributes.add("bypassConfirmation");
            }
            if (this.expirationBuildStage == -1) {
                attributes.add("expiration");
            }
            return "Cannot build ConfirmationConfiguration, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ConfirmationConfiguration", generator="Immutables")
    public static final class Builder<C>
    implements CacheBuildStage<C>,
    NoPendingCommandNotifierBuildStage<C>,
    ConfirmationRequiredNotifierBuildStage<C>,
    BuildFinal<C> {
        private static final long INIT_BIT_CACHE = 1L;
        private static final long INIT_BIT_NO_PENDING_COMMAND_NOTIFIER = 2L;
        private static final long INIT_BIT_CONFIRMATION_REQUIRED_NOTIFIER = 4L;
        private static final long OPT_BIT_BYPASS_CONFIRMATION = 1L;
        private static final long OPT_BIT_EXPIRATION = 2L;
        private long initBits = 7L;
        private long optBits;
        private @NonNull CloudCache<C, ConfirmationContext<C>> cache;
        private @NonNull Consumer<C> noPendingCommandNotifier;
        private @NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier;
        private @NonNull Predicate<CommandContext<C>> bypassConfirmation;
        private @Nullable Duration expiration;

        private Builder() {
        }

        @Override
        public final Builder<C> cache(@NonNull CloudCache<C, ConfirmationContext<C>> cache) {
            Builder.checkNotIsSet(this.cacheIsSet(), "cache");
            this.cache = Objects.requireNonNull(cache, "cache");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder<C> noPendingCommandNotifier(@NonNull Consumer<C> noPendingCommandNotifier) {
            Builder.checkNotIsSet(this.noPendingCommandNotifierIsSet(), "noPendingCommandNotifier");
            this.noPendingCommandNotifier = Objects.requireNonNull(noPendingCommandNotifier, "noPendingCommandNotifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder<C> confirmationRequiredNotifier(@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier) {
            Builder.checkNotIsSet(this.confirmationRequiredNotifierIsSet(), "confirmationRequiredNotifier");
            this.confirmationRequiredNotifier = Objects.requireNonNull(confirmationRequiredNotifier, "confirmationRequiredNotifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public final Builder<C> bypassConfirmation(@NonNull Predicate<CommandContext<C>> bypassConfirmation) {
            Builder.checkNotIsSet(this.bypassConfirmationIsSet(), "bypassConfirmation");
            this.bypassConfirmation = Objects.requireNonNull(bypassConfirmation, "bypassConfirmation");
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder<C> expiration(@Nullable Duration expiration) {
            Builder.checkNotIsSet(this.expirationIsSet(), "expiration");
            this.expiration = expiration;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableConfirmationConfiguration<C> build() {
            this.checkRequiredAttributes();
            return new ImmutableConfirmationConfiguration(this);
        }

        private boolean bypassConfirmationIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean expirationIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean cacheIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean noPendingCommandNotifierIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean confirmationRequiredNotifierIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ConfirmationConfiguration is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.cacheIsSet()) {
                attributes.add("cache");
            }
            if (!this.noPendingCommandNotifierIsSet()) {
                attributes.add("noPendingCommandNotifier");
            }
            if (!this.confirmationRequiredNotifierIsSet()) {
                attributes.add("confirmationRequiredNotifier");
            }
            return "Cannot build ConfirmationConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ConfirmationConfiguration", generator="Immutables")
    public static interface CacheBuildStage<C> {
        public NoPendingCommandNotifierBuildStage<C> cache(@NonNull CloudCache<C, ConfirmationContext<C>> var1);
    }

    @Generated(from="ConfirmationConfiguration", generator="Immutables")
    public static interface BuildFinal<C> {
        public BuildFinal<C> bypassConfirmation(@NonNull Predicate<CommandContext<C>> var1);

        public BuildFinal<C> expiration(@Nullable Duration var1);

        public ImmutableConfirmationConfiguration<C> build();
    }

    @Generated(from="ConfirmationConfiguration", generator="Immutables")
    public static interface ConfirmationRequiredNotifierBuildStage<C> {
        public BuildFinal<C> confirmationRequiredNotifier(@NonNull BiConsumer<C, ConfirmationContext<C>> var1);
    }

    @Generated(from="ConfirmationConfiguration", generator="Immutables")
    public static interface NoPendingCommandNotifierBuildStage<C> {
        public ConfirmationRequiredNotifierBuildStage<C> noPendingCommandNotifier(@NonNull Consumer<C> var1);
    }
}

