/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.processors.confirmation;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.org.incendo.cloud.Command;
import squaremap.libraries.org.incendo.cloud.execution.CommandExecutionHandler;
import squaremap.libraries.org.incendo.cloud.execution.postprocessor.CommandPostprocessor;
import squaremap.libraries.org.incendo.cloud.key.CloudKey;
import squaremap.libraries.org.incendo.cloud.processors.cache.CloudCache;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationConfiguration;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationContext;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationExecutionHandler;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationPostprocessor;

@API(status=API.Status.STABLE, since="1.0.0")
public final class ConfirmationManager<C>
implements Command.Builder.Applicable<C> {
    public static final CloudKey<Boolean> META_CONFIRMATION_REQUIRED = CloudKey.of("cloud:require_confirmation", Boolean.class);
    private final CloudCache<C, ConfirmationContext<C>> cache;
    private final ConfirmationConfiguration<C> configuration;

    public static <C> @NonNull ConfirmationManager<C> confirmationManager(@NonNull ConfirmationConfiguration<C> configuration) {
        return new ConfirmationManager<C>(Objects.requireNonNull(configuration, "configuration"));
    }

    public static <C> @NonNull ConfirmationManager<C> confirmationManager(@NonNull Function< @NonNull ImmutableConfirmationConfiguration.CacheBuildStage<C>,  @NonNull ImmutableConfirmationConfiguration.BuildFinal<C>> configuration) {
        return ConfirmationManager.confirmationManager(configuration.apply(ConfirmationConfiguration.builder()).build());
    }

    private ConfirmationManager(@NonNull ConfirmationConfiguration<C> configuration) {
        this.cache = Objects.requireNonNull(configuration.cache(), "cache");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public @NonNull ConfirmationConfiguration<C> configuration() {
        return this.configuration;
    }

    @Override
    public  @NonNull Command.Builder<C> applyToCommandBuilder( @NonNull Command.Builder<C> builder) {
        return builder.meta(META_CONFIRMATION_REQUIRED, true);
    }

    public @NonNull CommandExecutionHandler<C> createExecutionHandler() {
        return new ConfirmationExecutionHandler(this);
    }

    public @NonNull CommandPostprocessor<C> createPostprocessor() {
        return new ConfirmationPostprocessor(this);
    }

    public @NonNull Optional<ConfirmationContext<C>> popPending(@NonNull C sender) {
        Duration age;
        Objects.requireNonNull(sender, "sender");
        ConfirmationContext<C> context = this.cache.popIfPresent(sender);
        if (context == null) {
            return Optional.empty();
        }
        Duration expiration = this.configuration.expiration();
        if (expiration != null && (age = Duration.between(context.creationTime(), Instant.now())).compareTo(expiration) > 0) {
            return Optional.empty();
        }
        return Optional.of(context);
    }

    void addPending(@NonNull C sender, @NonNull ConfirmationContext<C> context) {
        Objects.requireNonNull(sender, "sender");
        Objects.requireNonNull(context, "context");
        this.cache.put(sender, context);
    }
}

