/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.injection;

import java.lang.annotation.Annotation;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.com.google.inject.BindingAnnotation;
import squaremap.libraries.com.google.inject.ConfigurationException;
import squaremap.libraries.com.google.inject.Injector;
import squaremap.libraries.com.google.inject.Key;
import squaremap.libraries.org.incendo.cloud.injection.InjectionRequest;
import squaremap.libraries.org.incendo.cloud.injection.InjectionService;
import squaremap.libraries.org.incendo.cloud.util.annotation.AnnotationAccessor;

@API(status=API.Status.STABLE)
public final class GuiceInjectionService<C>
implements InjectionService<C> {
    private final Injector injector;

    private static <T> @NonNull Key<T> createKey(@NonNull Class<T> clazz, @NonNull AnnotationAccessor annotationAccessor) {
        Annotation bindingAnnotation = annotationAccessor.annotations().stream().filter(annotation -> annotation.annotationType().isAnnotationPresent(BindingAnnotation.class)).findFirst().orElse(null);
        if (bindingAnnotation == null) {
            return Key.get(clazz);
        }
        return Key.get(clazz, bindingAnnotation);
    }

    private GuiceInjectionService(@NonNull Injector injector) {
        this.injector = injector;
    }

    public static <C> @NonNull GuiceInjectionService<C> create(@NonNull Injector injector) {
        return new GuiceInjectionService<C>(injector);
    }

    @Override
    public @Nullable Object handle(@NonNull InjectionRequest<C> request) {
        try {
            return this.injector.getInstance(GuiceInjectionService.createKey(request.injectedClass(), request.annotationAccessor()));
        }
        catch (ConfigurationException ignored) {
            return null;
        }
    }
}

