/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Set;
import squaremap.libraries.com.google.inject.internal.ConstructionProxyFactory;
import squaremap.libraries.com.google.inject.internal.ConstructorInjector;
import squaremap.libraries.com.google.inject.internal.DefaultConstructionProxyFactory;
import squaremap.libraries.com.google.inject.internal.Errors;
import squaremap.libraries.com.google.inject.internal.ErrorsException;
import squaremap.libraries.com.google.inject.internal.FailableCache;
import squaremap.libraries.com.google.inject.internal.InjectorImpl;
import squaremap.libraries.com.google.inject.internal.InternalFlags;
import squaremap.libraries.com.google.inject.internal.MembersInjectorImpl;
import squaremap.libraries.com.google.inject.internal.MethodAspect;
import squaremap.libraries.com.google.inject.internal.ProxyFactory;
import squaremap.libraries.com.google.inject.internal.SingleParameterInjector;
import squaremap.libraries.com.google.inject.spi.InjectionPoint;
import squaremap.libraries.com.google.inject.spi.InterceptorBinding;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    boolean isLoading(InjectionPoint ip) {
        return this.cache.isLoading(ip);
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<InterceptorBinding> injectorBindings = this.injector.getBindingData().getInterceptorBindings();
            ImmutableList methodAspects = ImmutableList.builder().addAll((Iterable)Lists.transform(injectorBindings, MethodAspect::fromBinding)).addAll(membersInjector.getAddedAspects()).build();
            factory = new ProxyFactory(injectionPoint, (Iterable<MethodAspect>)methodAspects);
        } else {
            factory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector((Set<InjectionPoint>)membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

