/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.AbstractConfig;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class WorldNameToKeyMigration {
    private WorldNameToKeyMigration() {
    }

    public static void migrate(AbstractConfig config, ServerLevel level) {
        String oldName = level.getWorld().getName();
        config.migrateLevelSection(level, oldName);
    }

    public static void tryMoveDirectories(DirectoryProvider directoryProvider, ServerLevel level) {
        try {
            WorldNameToKeyMigration.moveDirectories(directoryProvider, level);
        }
        catch (IOException ex) {
            Logging.logger().error("Failed to migrate directories for '{}'", (Object)level.dimension().identifier());
        }
    }

    private static void moveDirectories(DirectoryProvider directoryProvider, ServerLevel level) throws IOException {
        Path data;
        Path dataFrom;
        String oldName = level.getWorld().getName();
        String webName = Util.levelWebName(level);
        Path tilesFrom = directoryProvider.tilesDirectory().resolve(oldName);
        if (Files.exists(tilesFrom, new LinkOption[0])) {
            Path tilesDest = directoryProvider.tilesDirectory().resolve(webName);
            Files.move(tilesFrom, tilesDest, new CopyOption[0]);
        }
        if (Files.exists(dataFrom = (data = directoryProvider.dataDirectory().resolve("data")).resolve(oldName), new LinkOption[0])) {
            Path dataDest = data.resolve(webName);
            Files.move(dataFrom, dataDest, new CopyOption[0]);
        }
    }
}

