/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.AbstractPlayerManager;
import xyz.jpenilla.squaremap.common.ServerAccess;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class PaperPlayerManager
extends AbstractPlayerManager {
    public final NamespacedKey hiddenKey;

    @Inject
    private PaperPlayerManager(JavaPlugin plugin, ServerAccess serverAccess) {
        super(serverAccess);
        this.hiddenKey = new NamespacedKey((Plugin)plugin, "hidden");
    }

    @Override
    protected boolean persistentHidden(ServerPlayer player) {
        return (Byte)PaperPlayerManager.pdc(player).getOrDefault(this.hiddenKey, PersistentDataType.BYTE, (Object)0) != 0;
    }

    @Override
    protected void persistentHidden(ServerPlayer player, boolean value) {
        PaperPlayerManager.pdc(player).set(this.hiddenKey, PersistentDataType.BYTE, (Object)((byte)(value ? 1 : 0)));
    }

    @Override
    public boolean otherwiseHidden(ServerPlayer player) {
        return player.getBukkitEntity().hasMetadata("NPC");
    }

    @Override
    public Component displayName(ServerPlayer player) {
        return player.getBukkitEntity().displayName();
    }

    private static PersistentDataContainer pdc(ServerPlayer player) {
        return player.getBukkitEntity().getPersistentDataContainer();
    }
}

