/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.assistedinject.Assisted;
import squaremap.libraries.com.google.inject.assistedinject.AssistedInject;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.data.Image;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;
import xyz.jpenilla.squaremap.common.task.render.AbstractRender;
import xyz.jpenilla.squaremap.common.task.render.RenderProgress;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.util.SpiralIterator;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProviderFactory;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityLimitImpl;

@DefaultQualifier(value=NonNull.class)
public final class RadiusRender
extends AbstractRender {
    private final ServerAccess serverAccess;
    private final int centerX;
    private final int centerZ;
    private final int radius;
    private final int totalChunks;

    @AssistedInject
    private RadiusRender(@Assisted MapWorldInternal world, @Assisted BlockPos center, @Assisted int radius, ChunkSnapshotProviderFactory chunkSnapshotProviderFactory, ServerAccess serverAccess) {
        super(world, chunkSnapshotProviderFactory);
        this.radius = Numbers.blockToChunk(radius);
        this.centerX = Numbers.blockToChunk(center.getX());
        this.centerZ = Numbers.blockToChunk(center.getZ());
        this.totalChunks = this.countTotalChunks();
        this.serverAccess = serverAccess;
    }

    private int countTotalChunks() {
        int count = 0;
        VisibilityLimitImpl visibility = this.mapWorld.visibilityLimit();
        for (int chunkX = this.centerX - this.radius; chunkX <= this.centerX + this.radius; ++chunkX) {
            for (int chunkZ = this.centerZ - this.radius; chunkZ <= this.centerZ + this.radius; ++chunkZ) {
                if (!visibility.shouldRenderChunk(chunkX, chunkZ)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int totalChunks() {
        return this.totalChunks;
    }

    @Override
    public int totalRegions() {
        return -1;
    }

    @Override
    protected void render() {
        try {
            this.serverAccess.blockSleep();
            this.render0();
        }
        finally {
            this.serverAccess.allowSleep();
        }
    }

    private void render0() {
        Logging.info(Messages.LOG_STARTED_RADIUSRENDER, "world", this.mapWorld.identifier().asString());
        this.progress = RenderProgress.printProgress(this);
        Iterator<ChunkCoordinate> spiral = SpiralIterator.chunk(this.centerX, this.centerZ, this.radius);
        LinkedHashMap<RegionCoordinate, List> chunks = new LinkedHashMap<RegionCoordinate, List>();
        while (spiral.hasNext() && this.running()) {
            ChunkCoordinate chunkCoord = spiral.next();
            RegionCoordinate region = chunkCoord.regionCoordinate();
            if (!this.mapWorld.visibilityLimit().shouldRenderChunk(chunkCoord)) continue;
            chunks.computeIfAbsent(region, $ -> new ArrayList()).add(chunkCoord);
        }
        for (Map.Entry entry : chunks.entrySet()) {
            if (!this.running()) break;
            RegionCoordinate region = (RegionCoordinate)entry.getKey();
            List chunkCoords = (List)entry.getValue();
            if (chunkCoords.size() == 1024) {
                this.mapRegion(region);
                continue;
            }
            Image image = new Image(region, this.mapWorld.tilesPath(), this.mapWorld.config().ZOOM_MAX);
            ArrayList<CompletableFuture<Void>> chunkFutures = new ArrayList<CompletableFuture<Void>>();
            for (ChunkCoordinate chunkCoord : chunkCoords) {
                chunkFutures.add(this.mapSingleChunk(image, chunkCoord.x(), chunkCoord.z()));
            }
            try {
                CompletableFuture.allOf((CompletableFuture[])chunkFutures.toArray(CompletableFuture[]::new)).get();
            }
            catch (InterruptedException ignore) {
                break;
            }
            catch (CancellationException | ExecutionException ex) {
                Logging.logger().error("Exception executing radius render for region {}", (Object)region, (Object)ex);
                break;
            }
            if (!this.running()) continue;
            this.mapWorld.saveImage(image);
        }
    }
}

