/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.org.spongepowered.configurate.ConfigurateException;
import squaremap.libraries.org.spongepowered.configurate.ConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class ConfigUpgrader {
    private final ConfigurationTransformation.Versioned upgrader;

    public ConfigUpgrader(Consumer<ConfigurationTransformation.VersionedBuilder> op) {
        ConfigurationTransformation.VersionedBuilder builder = ConfigurationTransformation.versionedBuilder();
        op.accept(builder);
        this.upgrader = builder.build();
    }

    public <N extends ConfigurationNode> UpgradeResult<N> upgrade(N node) {
        int original = this.upgrader.version(node);
        try {
            this.upgrader.apply(node);
        }
        catch (ConfigurateException e) {
            Util.rethrow(e);
        }
        int newVer = this.upgrader.version(node);
        return new UpgradeResult<N>(original, newVer, node, original != newVer);
    }

    public record UpgradeResult<N extends ConfigurationNode>(int originalVersion, int newVersion, N node, boolean didUpgrade) {
    }
}

