/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.util.chunksnapshot;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProvider;
import xyz.jpenilla.squaremap.paper.util.Folia;

@DefaultQualifier(value=NonNull.class)
record PaperChunkSnapshotProvider(ServerLevel level, Server server, JavaPlugin plugin) implements ChunkSnapshotProvider
{
    @Override
    public CompletableFuture<@Nullable ChunkSnapshot> asyncSnapshot(int x, int z) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkSnapshot snapshot;
            @Nullable ChunkAccess existing = this.level.getChunkIfLoadedImmediately(x, z);
            if (existing != null && (snapshot = this.maybeSnapshot(existing)) != null) {
                return CompletableFuture.completedFuture(snapshot);
            }
            CompletableFuture<@Nullable T> load = new CompletableFuture();
            PlatformHooks.get().scheduleChunkLoad(this.level, x, z, ChunkStatus.EMPTY, true, Priority.NORMAL, chunk -> load.complete(this.maybeSnapshot((ChunkAccess)chunk)));
            return load;
        }, this.executor(x, z)).thenCompose(future -> future);
    }

    private @Nullable ChunkSnapshot maybeSnapshot(@Nullable ChunkAccess chunk) {
        if (chunk == null) {
            return null;
        }
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposter = (ImposterProtoChunk)chunk;
            chunk = imposter.getWrapped();
        }
        if (!(chunk.getPersistedStatus().isOrAfter(ChunkStatus.FULL) || chunk.getBelowZeroRetrogen() != null && chunk.getBelowZeroRetrogen().targetStatus().isOrAfter(ChunkStatus.SPAWN))) {
            return null;
        }
        return ChunkSnapshot.snapshot((Level)this.level, chunk, false);
    }

    private Executor executor(int x, int z) {
        if (!Folia.FOLIA) {
            return task -> {
                if (this.level.getServer().isSameThread()) {
                    task.run();
                    return;
                }
                this.level.getServer().execute(task);
            };
        }
        return task -> {
            if (this.server.isOwnedByCurrentRegion((World)this.level.getWorld(), x, z)) {
                task.run();
                return;
            }
            this.server.getRegionScheduler().execute((Plugin)this.plugin, (World)this.level.getWorld(), x, z, task);
        };
    }
}

