/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.listener;

import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.paper.PaperWorldManager;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitHelper;

@DefaultQualifier(value=NonNull.class)
public final class WorldLoadListener
implements Listener {
    private final PaperWorldManager worldManager;

    @Inject
    private WorldLoadListener(PaperWorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void handleWorldLoad(WorldLoadEvent event) {
        this.worldManager.initWorld(CraftBukkitHelper.serverLevel(event.getWorld()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handleWorldUnload(WorldUnloadEvent event) {
        this.worldManager.worldUnloaded(CraftBukkitHelper.serverLevel(event.getWorld()));
    }
}

