/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import java.util.EnumMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotImpl;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.EmptySectionHolder;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.HeightmapSnapshot;

@DefaultQualifier(value=NonNull.class)
public interface ChunkSnapshot
extends LevelHeightAccessor,
BiomeManager.NoiseBiomeSource {
    public BlockState getBlockState(BlockPos var1);

    public FluidState getFluidState(BlockPos var1);

    public int getHeight(Heightmap.Types var1, int var2, int var3);

    public DimensionType dimensionType();

    public ChunkPos pos();

    public boolean sectionEmpty(int var1);

    public static ChunkSnapshot snapshot(Level level, ChunkAccess chunk, boolean biomesOnly) {
        LevelHeightAccessor heightAccessor = LevelHeightAccessor.create((int)chunk.getMinY(), (int)chunk.getHeight());
        int sectionCount = heightAccessor.getSectionsCount();
        LevelChunkSection[] sections = chunk.getSections();
        PalettedContainer[] states = new PalettedContainer[sectionCount];
        PalettedContainer[] biomes = new PalettedContainer[sectionCount];
        boolean[] empty = new boolean[sectionCount];
        EnumMap<Heightmap.Types, HeightmapSnapshot> heightmaps = ChunkSnapshotImpl.EMPTY_HEIGHTMAPS;
        if (!biomesOnly) {
            if (!chunk.hasPrimedHeightmap(Heightmap.Types.WORLD_SURFACE)) {
                if (chunk.getBelowZeroRetrogen() == null) {
                    throw new IllegalStateException("Expected WORLD_SURFACE heightmap to be present, but it wasn't! " + String.valueOf(chunk.getPos()));
                }
                Heightmap.primeHeightmaps((ChunkAccess)chunk, Set.of(Heightmap.Types.WORLD_SURFACE));
            }
            heightmaps = new EnumMap<Heightmap.Types, HeightmapSnapshot>(ChunkSnapshotImpl.EMPTY_HEIGHTMAPS);
            heightmaps.put(Heightmap.Types.WORLD_SURFACE, new HeightmapSnapshot(chunk, heightAccessor, Heightmap.Types.WORLD_SURFACE));
            for (int i = 0; i < sectionCount; ++i) {
                boolean sectionEmpty;
                empty[i] = sectionEmpty = sections[i].hasOnlyAir();
                states[i] = sectionEmpty ? EmptySectionHolder.getEmptySectionBlockStates() : sections[i].getStates().copy();
                biomes[i] = ((PalettedContainer)sections[i].getBiomes()).copy();
            }
        } else {
            for (int i = 0; i < sectionCount; ++i) {
                biomes[i] = ((PalettedContainer)sections[i].getBiomes()).copy();
            }
        }
        return new ChunkSnapshotImpl(heightAccessor, states, biomes, heightmaps, empty, level.dimensionType(), chunk.getPos());
    }
}

