/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.argument.parser;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.context.CommandInput;
import squaremap.libraries.org.incendo.cloud.parser.ArgumentParseResult;
import squaremap.libraries.org.incendo.cloud.parser.ArgumentParser;
import squaremap.libraries.org.incendo.cloud.parser.ParserDescriptor;
import squaremap.libraries.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.argument.parser.MapWorldParser;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class LevelParser<C>
implements ArgumentParser<C, ServerLevel>,
BlockingSuggestionProvider.Strings<C> {
    public static <C> ParserDescriptor<C, ServerLevel> levelParser() {
        return ParserDescriptor.of(new LevelParser<C>(), ServerLevel.class);
    }

    @Override
    public ArgumentParseResult<ServerLevel> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.readString();
        @Nullable Identifier key = Identifier.tryParse((String)input);
        if (key == null || key.getPath().isEmpty()) {
            return ArgumentParseResult.failure(new MapWorldParser.MapWorldParseException(input, MapWorldParser.MapWorldParseException.FailureReason.NO_SUCH_WORLD));
        }
        @Nullable ServerLevel world = commandContext.get(Commands.SERVER_ACCESS).level(Util.worldIdentifier(key));
        if (world == null) {
            return ArgumentParseResult.failure(new MapWorldParser.MapWorldParseException(input, MapWorldParser.MapWorldParseException.FailureReason.NO_SUCH_WORLD));
        }
        return ArgumentParseResult.success(world);
    }

    public List<String> stringSuggestions(CommandContext<C> commandContext, CommandInput commandInput) {
        return commandContext.get(Commands.SERVER_ACCESS).levels().stream().flatMap((? super T mapWorld) -> {
            Identifier identifier = mapWorld.dimension().identifier();
            if (!commandInput.remainingInput().isBlank() && identifier.getNamespace().equals("minecraft")) {
                return Stream.of(identifier.getPath(), identifier.toString());
            }
            return Stream.of(identifier.toString());
        }).toList();
    }
}

