/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.html;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import squaremap.libraries.org.owasp.html.AttributePolicy;
import squaremap.libraries.org.owasp.html.ElementAndAttributePolicies;
import squaremap.libraries.org.owasp.html.ElementAndAttributePolicyBasedSanitizerPolicy;
import squaremap.libraries.org.owasp.html.Handler;
import squaremap.libraries.org.owasp.html.HtmlChangeListener;
import squaremap.libraries.org.owasp.html.HtmlChangeReporter;
import squaremap.libraries.org.owasp.html.HtmlSanitizer;
import squaremap.libraries.org.owasp.html.HtmlStreamEventProcessor;
import squaremap.libraries.org.owasp.html.HtmlStreamEventReceiver;
import squaremap.libraries.org.owasp.html.HtmlStreamRenderer;
import squaremap.libraries.org.owasp.html.TCB;

@ThreadSafe
@Immutable
@TCB
public final class PolicyFactory
implements Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> {
    private final Map<String, ElementAndAttributePolicies> policies;
    private final Map<String, AttributePolicy> globalAttrPolicies;
    private final Set<String> textContainers;
    private final HtmlStreamEventProcessor preprocessor;
    private final HtmlStreamEventProcessor postprocessor;

    PolicyFactory(Map<String, ElementAndAttributePolicies> policies, Set<String> textContainers, Map<String, AttributePolicy> globalAttrPolicies, HtmlStreamEventProcessor preprocessor, HtmlStreamEventProcessor postprocessor) {
        this.policies = policies;
        this.textContainers = textContainers;
        this.globalAttrPolicies = globalAttrPolicies;
        this.preprocessor = preprocessor;
        this.postprocessor = postprocessor;
    }

    @Override
    public HtmlSanitizer.Policy apply(@Nonnull HtmlStreamEventReceiver out) {
        return new ElementAndAttributePolicyBasedSanitizerPolicy(this.postprocessor.wrap(out), this.policies, this.textContainers);
    }

    public <CTX> HtmlSanitizer.Policy apply(HtmlStreamEventReceiver out, @Nullable HtmlChangeListener<CTX> listener, @Nullable CTX context) {
        if (listener == null) {
            return this.apply(out);
        }
        HtmlChangeReporter<CTX> r = new HtmlChangeReporter<CTX>(out, listener, context);
        r.setPolicy(this.apply(r.getWrappedRenderer()));
        return r.getWrappedPolicy();
    }

    public String sanitize(@Nullable String html) {
        return this.sanitize(html, null, null);
    }

    public <CTX> String sanitize(@Nullable String html, @Nullable HtmlChangeListener<CTX> listener, @Nullable CTX context) {
        if (html == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(html.length());
        HtmlSanitizer.sanitize(html, this.apply(HtmlStreamRenderer.create(out, Handler.DO_NOTHING), listener, context), this.preprocessor);
        return out.toString();
    }

    public PolicyFactory and(PolicyFactory f) {
        Map<String, AttributePolicy> allGlobalAttrPolicies;
        Set<String> allTextContainers;
        Object p;
        String elName;
        HashMap<String, ElementAndAttributePolicies> builder = new HashMap<String, ElementAndAttributePolicies>();
        for (Map.Entry<String, ElementAndAttributePolicies> e : this.policies.entrySet()) {
            elName = e.getKey();
            p = e.getValue();
            ElementAndAttributePolicies q = f.policies.get(elName);
            p = q != null ? ((ElementAndAttributePolicies)p).and(q) : ((ElementAndAttributePolicies)p).andGlobals(f.globalAttrPolicies);
            builder.put(elName, (ElementAndAttributePolicies)p);
        }
        for (Map.Entry<String, ElementAndAttributePolicies> e : f.policies.entrySet()) {
            elName = e.getKey();
            if (this.policies.containsKey(elName)) continue;
            p = e.getValue();
            p = ((ElementAndAttributePolicies)p).andGlobals(this.globalAttrPolicies);
            builder.put(elName, (ElementAndAttributePolicies)p);
        }
        if (this.textContainers.containsAll(f.textContainers)) {
            allTextContainers = this.textContainers;
        } else if (f.textContainers.containsAll(this.textContainers)) {
            allTextContainers = f.textContainers;
        } else {
            HashSet containerBuilder = new HashSet();
            this.textContainers.forEach(containerBuilder::add);
            f.textContainers.forEach(containerBuilder::add);
            allTextContainers = Collections.unmodifiableSet(containerBuilder);
        }
        if (f.globalAttrPolicies.isEmpty()) {
            allGlobalAttrPolicies = this.globalAttrPolicies;
        } else if (this.globalAttrPolicies.isEmpty()) {
            allGlobalAttrPolicies = f.globalAttrPolicies;
        } else {
            String attrName;
            HashMap<String, AttributePolicy> ab = new HashMap<String, AttributePolicy>();
            for (Map.Entry<String, AttributePolicy> e : this.globalAttrPolicies.entrySet()) {
                attrName = (String)e.getKey();
                ab.put(attrName, AttributePolicy.Util.join(e.getValue(), f.globalAttrPolicies.get(attrName)));
            }
            for (Map.Entry<String, AttributePolicy> e : f.globalAttrPolicies.entrySet()) {
                attrName = e.getKey();
                if (this.globalAttrPolicies.containsKey(attrName)) continue;
                ab.put(attrName, e.getValue());
            }
            allGlobalAttrPolicies = Collections.unmodifiableMap(ab);
        }
        HtmlStreamEventProcessor compositionOfPreprocessors = HtmlStreamEventProcessor.Processors.compose(this.preprocessor, f.preprocessor);
        HtmlStreamEventProcessor compositionOfPostprocessors = HtmlStreamEventProcessor.Processors.compose(this.postprocessor, f.postprocessor);
        return new PolicyFactory(Collections.unmodifiableMap(builder), allTextContainers, allGlobalAttrPolicies, compositionOfPreprocessors, compositionOfPostprocessors);
    }
}

