/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import squaremap.libraries.com.google.inject.Binder;
import squaremap.libraries.com.google.inject.Injector;
import squaremap.libraries.com.google.inject.Key;
import squaremap.libraries.com.google.inject.Module;
import squaremap.libraries.com.google.inject.Provider;
import squaremap.libraries.com.google.inject.Scopes;
import squaremap.libraries.com.google.inject.Singleton;
import squaremap.libraries.com.google.inject.Stage;
import squaremap.libraries.com.google.inject.internal.BindingProcessor;
import squaremap.libraries.com.google.inject.internal.ConstantFactory;
import squaremap.libraries.com.google.inject.internal.Errors;
import squaremap.libraries.com.google.inject.internal.GuiceInternal;
import squaremap.libraries.com.google.inject.internal.Initializables;
import squaremap.libraries.com.google.inject.internal.Initializer;
import squaremap.libraries.com.google.inject.internal.InjectorBindingData;
import squaremap.libraries.com.google.inject.internal.InjectorImpl;
import squaremap.libraries.com.google.inject.internal.InjectorJitBindingData;
import squaremap.libraries.com.google.inject.internal.InjectorOptionsProcessor;
import squaremap.libraries.com.google.inject.internal.InstanceBindingImpl;
import squaremap.libraries.com.google.inject.internal.InterceptorBindingProcessor;
import squaremap.libraries.com.google.inject.internal.InternalContext;
import squaremap.libraries.com.google.inject.internal.InternalFactory;
import squaremap.libraries.com.google.inject.internal.ListenerBindingProcessor;
import squaremap.libraries.com.google.inject.internal.MembersInjectorStore;
import squaremap.libraries.com.google.inject.internal.MessageProcessor;
import squaremap.libraries.com.google.inject.internal.ModuleAnnotatedMethodScannerProcessor;
import squaremap.libraries.com.google.inject.internal.PrivateElementProcessor;
import squaremap.libraries.com.google.inject.internal.PrivateElementsImpl;
import squaremap.libraries.com.google.inject.internal.ProcessedBindingData;
import squaremap.libraries.com.google.inject.internal.ProviderInstanceBindingImpl;
import squaremap.libraries.com.google.inject.internal.ProvisionListenerCallbackStore;
import squaremap.libraries.com.google.inject.internal.ScopeBindingProcessor;
import squaremap.libraries.com.google.inject.internal.Scoping;
import squaremap.libraries.com.google.inject.internal.TypeConverterBindingProcessor;
import squaremap.libraries.com.google.inject.internal.UntargettedBindingProcessor;
import squaremap.libraries.com.google.inject.internal.util.ContinuousStopwatch;
import squaremap.libraries.com.google.inject.internal.util.SourceProvider;
import squaremap.libraries.com.google.inject.spi.BindingSourceRestriction;
import squaremap.libraries.com.google.inject.spi.Dependency;
import squaremap.libraries.com.google.inject.spi.Element;
import squaremap.libraries.com.google.inject.spi.Elements;
import squaremap.libraries.com.google.inject.spi.InjectionPoint;
import squaremap.libraries.com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import squaremap.libraries.com.google.inject.spi.PrivateElements;
import squaremap.libraries.com.google.inject.spi.ProvisionListenerBinding;
import squaremap.libraries.com.google.inject.spi.TypeListenerBinding;

final class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;

    private InjectorShell(List<Element> elements, InjectorImpl injector) {
        this.elements = elements;
        this.injector = injector;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injector) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injector);
        injector.getBindingData().putBinding(key, new ProviderInstanceBindingImpl<Injector>(injector, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, (Set<InjectionPoint>)ImmutableSet.of()));
    }

    private static void bindLogger(InjectorImpl injector) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injector.getBindingData().putBinding(key, new ProviderInstanceBindingImpl<Logger>(injector, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, (Set<InjectionPoint>)ImmutableSet.of()));
    }

    private static void bindStage(InjectorImpl injector, Stage stage) {
        Key<Stage> key = Key.get(Stage.class);
        InstanceBindingImpl<Stage> stageBinding = new InstanceBindingImpl<Stage>(injector, key, SourceProvider.UNKNOWN_SOURCE, new ConstantFactory<Stage>(Initializables.of(stage)), (Set<InjectionPoint>)ImmutableSet.of(), stage);
        injector.getBindingData().putBinding(key, stageBinding);
    }

    private static class InheritedScannersModule
    implements Module {
        private final InjectorBindingData bindingData;

        InheritedScannersModule(InjectorBindingData bindingData) {
            this.bindingData = bindingData;
        }

        @Override
        public void configure(Binder binder) {
            for (ModuleAnnotatedMethodScannerBinding binding : this.bindingData.getScannerBindings()) {
                binding.applyTo(binder);
            }
        }
    }

    private static class RootModule
    implements Module {
        private RootModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.withSource(SourceProvider.UNKNOWN_SOURCE);
            binder.bindScope(Singleton.class, Scopes.SINGLETON);
            binder.bindScope(squaremap.libraries.jakarta.inject.Singleton.class, Scopes.SINGLETON);
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Provider<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(InternalContext context, Dependency<?> dependency, boolean linked) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "Provider<Logger>";
        }
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Provider<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(InternalContext context, Dependency<?> dependency, boolean linked) {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "Provider<Injector>";
        }
    }

    static class Builder {
        private final List<Element> elements = Lists.newArrayList();
        private final List<Module> modules = Lists.newArrayList();
        private InjectorBindingData bindingData;
        private InjectorJitBindingData jitBindingData;
        private InjectorImpl parent;
        private InjectorImpl.InjectorOptions options;
        private Stage stage;
        private PrivateElementsImpl privateElements;

        Builder() {
        }

        Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        Builder parent(InjectorImpl parent) {
            this.parent = parent;
            this.jitBindingData = new InjectorJitBindingData(Optional.of(parent.getJitBindingData()));
            this.bindingData = new InjectorBindingData(Optional.of(parent.getBindingData()));
            this.options = parent.options;
            this.stage = this.options.stage;
            return this;
        }

        Builder privateElements(PrivateElements privateElements) {
            this.privateElements = (PrivateElementsImpl)privateElements;
            this.elements.addAll(privateElements.getElements());
            return this;
        }

        void addModules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        Stage getStage() {
            return this.options.stage;
        }

        Object lock() {
            if (this.bindingData == null) {
                this.jitBindingData = new InjectorJitBindingData(Optional.empty());
                this.bindingData = new InjectorBindingData(Optional.empty());
            }
            return this.jitBindingData.lock();
        }

        List<InjectorShell> build(Initializer initializer, ProcessedBindingData processedBindingData, ContinuousStopwatch stopwatch, Errors errors) {
            Preconditions.checkState((this.stage != null ? 1 : 0) != 0, (Object)"Stage not initialized");
            Preconditions.checkState((this.privateElements == null || this.parent != null ? 1 : 0) != 0, (Object)"PrivateElements with no parent");
            Preconditions.checkState((this.bindingData != null ? 1 : 0) != 0, (Object)"no binding data. Did you remember to lock() ?");
            Preconditions.checkState((this.privateElements == null && this.elements.isEmpty() || this.modules.isEmpty() ? 1 : 0) != 0, (Object)"The shell is either built from modules (root) or from PrivateElements (children).");
            if (this.parent == null) {
                this.modules.add(0, new RootModule());
            } else {
                this.modules.add(0, new InheritedScannersModule(this.parent.getBindingData()));
            }
            this.elements.addAll(Elements.getElements(this.stage, this.modules));
            if (this.privateElements == null) {
                this.elements.addAll((Collection<Element>)BindingSourceRestriction.check(GuiceInternal.GUICE_INTERNAL, this.elements));
            }
            InjectorOptionsProcessor optionsProcessor = new InjectorOptionsProcessor(errors);
            optionsProcessor.process(null, this.elements);
            this.options = optionsProcessor.getOptions(this.stage, this.options);
            InjectorImpl injector = new InjectorImpl(this.parent, this.bindingData, this.jitBindingData, this.options);
            if (this.privateElements != null) {
                this.privateElements.initInjector(injector);
            }
            if (this.parent == null) {
                TypeConverterBindingProcessor.prepareBuiltInConverters(injector);
            }
            stopwatch.resetAndLog("Module execution");
            new MessageProcessor(errors).process(injector, this.elements);
            new InterceptorBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Interceptors creation");
            new ListenerBindingProcessor(errors).process(injector, this.elements);
            ImmutableList<TypeListenerBinding> typeListenerBindings = injector.getBindingData().getTypeListenerBindings();
            injector.membersInjectorStore = new MembersInjectorStore(injector, (List<TypeListenerBinding>)typeListenerBindings);
            ImmutableList<ProvisionListenerBinding> provisionListenerBindings = injector.getBindingData().getProvisionListenerBindings();
            injector.provisionListenerStore = new ProvisionListenerCallbackStore((List<ProvisionListenerBinding>)provisionListenerBindings);
            stopwatch.resetAndLog("TypeListeners & ProvisionListener creation");
            new ScopeBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Converters creation");
            InjectorShell.bindStage(injector, this.stage);
            InjectorShell.bindInjector(injector);
            InjectorShell.bindLogger(injector);
            new BindingProcessor(errors, initializer, processedBindingData).process(injector, this.elements);
            new UntargettedBindingProcessor(errors, processedBindingData).process(injector, this.elements);
            stopwatch.resetAndLog("Binding creation");
            new ModuleAnnotatedMethodScannerProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Module annotated method scanners creation");
            ArrayList injectorShells = Lists.newArrayList();
            injectorShells.add(new InjectorShell(this.elements, injector));
            PrivateElementProcessor processor = new PrivateElementProcessor(errors);
            processor.process(injector, this.elements);
            for (Builder builder : processor.getInjectorShellBuilders()) {
                injectorShells.addAll(builder.build(initializer, processedBindingData, stopwatch, errors));
            }
            stopwatch.resetAndLog("Private environment creation");
            return injectorShells;
        }
    }
}

