/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.util.chunksnapshot;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.util.TickThread;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProvider;
import xyz.jpenilla.squaremap.paper.util.Folia;

record PaperChunkSnapshotProvider(WorldServer level, Server server, JavaPlugin plugin) implements ChunkSnapshotProvider
{
    @Override
    public CompletableFuture<@Nullable ChunkSnapshot> asyncSnapshot(int x, int z) {
        return CompletableFuture.supplyAsync(() -> {
            @Nullable IChunkAccess existing = this.level.getChunkIfLoadedImmediately(x, z);
            if (existing != null && existing.j().b(ChunkStatus.n)) {
                return CompletableFuture.completedFuture(existing);
            }
            if (existing != null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<@Nullable T> load = new CompletableFuture();
            ChunkSystem.scheduleChunkLoad((WorldServer)this.level, (int)x, (int)z, (ChunkStatus)ChunkStatus.c, (boolean)true, (PrioritisedExecutor.Priority)PrioritisedExecutor.Priority.NORMAL, load::complete);
            return load;
        }, this.executor(x, z)).thenCompose(chunkFuture -> chunkFuture.thenApplyAsync(chunk -> {
            if (chunk == null) {
                return null;
            }
            if (chunk instanceof ProtoChunkExtension) {
                ProtoChunkExtension imposter = (ProtoChunkExtension)chunk;
                chunk = imposter.C();
            }
            if (!(chunk.j().b(ChunkStatus.n) || chunk.x() != null && chunk.x().a().b(ChunkStatus.m))) {
                return null;
            }
            return ChunkSnapshot.snapshot((World)this.level, chunk, false);
        }, this.executor(x, z)));
    }

    private Executor executor(int x, int z) {
        if (!Folia.FOLIA) {
            return this.level.n();
        }
        return task -> {
            if (TickThread.isTickThreadFor((WorldServer)this.level, (int)x, (int)z)) {
                task.run();
                return;
            }
            this.server.getRegionScheduler().execute((Plugin)this.plugin, (org.bukkit.World)this.level.getWorld(), x, z, task);
        };
    }
}

